/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.analytics_xtreme.AnalyticsXtremeConfiguration;
import com.gigaspaces.analytics_xtreme.AnalyticsXtremeService;
import com.gigaspaces.jdbc.InsightEdgePreparedStatement;
import com.gigaspaces.jdbc.InsightEdgeSchema;
import com.gigaspaces.jdbc.InsightEdgeStatement;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.openspaces.core.GigaSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightEdgeConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(InsightEdgeConnection.class);
    private final CalciteConnection connection;
    private final InsightEdgeSchema schema;

    public InsightEdgeConnection(Connection connection) {
        this.connection = (CalciteConnection)connection;
        String spaceName = this.getProperties().getProperty("spaceName");
        this.schema = (InsightEdgeSchema)CalciteSchema.from((SchemaPlus)this.connection.getRootSchema().getSubSchema((String)spaceName)).schema;
        this.initializeAnalticsXtreme();
    }

    private void initializeAnalticsXtreme() {
        boolean isAxEnabled = Boolean.parseBoolean(this.connection.getProperties().getProperty("analyticsXtreme.enabled"));
        AnalyticsXtremeConfiguration config = (AnalyticsXtremeConfiguration)this.connection.getProperties().get("analyticsXtreme.config");
        if (config == null && isAxEnabled) {
            config = AnalyticsXtremeService.proxy((GigaSpace)this.schema.getSpace()).getConfiguration();
        }
        this.schema.setAnalyticsXtremeConfig(config);
        if (isAxEnabled && config == null) {
            throw new RuntimeException("AnalyticsXtreme is enabled but no configuration was found");
        }
    }

    public Properties getProperties() {
        return this.connection.getProperties();
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.connection.createStatement();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            LOG.debug("Creating prepared statement for query: {}", (Object)sql);
            return new InsightEdgePreparedStatement(this.connection.prepareStatement(sql));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("The driver doesn't support stored procedures.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("The driver doesn't support native sql.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.connection.commit();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.connection.close();
            if (this.schema.getAnalyticsXtremeConfig() != null) {
                this.schema.getAnalyticsXtremeConfig().getPolicies().values().forEach(policy -> {
                    try {
                        policy.getBatchDataSource().close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close data target for type " + policy.getTypeName(), (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.connection.isClosed();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.connection.getMetaData();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.connection.isReadOnly();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.connection.setCatalog(catalog);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.connection.getCatalog();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.connection.getWarnings();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.connection.clearWarnings();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return new InsightEdgeStatement(this.connection.createStatement(resultSetType, resultSetConcurrency));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            LOG.debug("Creating prepared statement for query: {}, resultSetType: {}, resultSetConcurrency: {}", new Object[]{sql, resultSetType, resultSetConcurrency});
            return new InsightEdgePreparedStatement(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            throw new UnsupportedOperationException("The driver doesn't support stored procedures.");
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.connection.getTypeMap();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.connection.setTypeMap(map);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.connection.setHoldability(holdability);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.connection.getHoldability();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.connection.setSavepoint();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.connection.setSavepoint(name);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.connection.rollback(savepoint);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return new InsightEdgeStatement(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            LOG.debug("Creating prepared statement for query: {}, resultSetType: {}, resultSetConcurrency: {}, resultSetHoldability: {}", new Object[]{sql, resultSetType, resultSetConcurrency, resultSetHoldability});
            return new InsightEdgePreparedStatement(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            throw new UnsupportedOperationException("The driver doesn't support stored procedures.");
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LOG.debug("Creating prepared statement for query: {}, autoGeneratedKeys: {}", (Object)sql, (Object)autoGeneratedKeys);
            return new InsightEdgePreparedStatement(this.connection.prepareStatement(sql, autoGeneratedKeys));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating prepared statement for query: {}, columnIndexes: {}", (Object)sql, (Object)Arrays.toString(columnIndexes));
            }
            return new InsightEdgePreparedStatement(this.connection.prepareStatement(sql, columnIndexes));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating prepared statement for query: {}, columnNames: {}", (Object)sql, (Object)Arrays.toString(columnNames));
            }
            return new InsightEdgePreparedStatement(this.connection.prepareStatement(sql, columnNames));
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.connection.createClob();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.connection.createBlob();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.connection.createNClob();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.connection.createSQLXML();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return !this.isClosed();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.connection.setClientInfo(name, value);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.connection.setClientInfo(properties);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.connection.getClientInfo(name);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.connection.getClientInfo();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.connection.createArrayOf(typeName, elements);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            throw new UnsupportedOperationException("The driver doesn't support struct.");
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.connection.setSchema(schema);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.connection.getSchema();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.connection.abort(executor);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.connection.setNetworkTimeout(executor, milliseconds);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.connection.getNetworkTimeout();
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this.connection.unwrap(iface);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.connection.isWrapperFor(iface);
        }
        catch (Exception e) {
            LOG.error("Fail in connection wrapper: ", (Throwable)e);
            throw e;
        }
    }
}

