/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public class InsightEdgeDriverProps
implements Serializable {
    public static final String SPACE_NAME_KEY = "spaceName";
    public static final String SPACE_URL_KEY = "url";
    public static final String USER_KEY = "user";
    public static final String PASSWORD_KEY = "password";
    public static final String DISABLE_SERVER_SIDE_JOINS_KEY = "disableServerSideJoins";
    public static final String PREFER_SPACE_ITERATOR = "preferSpaceIterator";
    public static final String ANALYTICS_XTREME_ENABLED = "analyticsXtreme.enabled";
    private final String spaceName;
    private final String spaceUrl;
    private final String user;
    private final String password;
    private final boolean disableServerSideJoins;
    private final boolean preferSpaceIterator;
    private Calendar connectionCalendar;

    public InsightEdgeDriverProps(Map<String, Object> properties) {
        this.spaceName = (String)properties.get(SPACE_NAME_KEY);
        this.spaceUrl = (String)properties.get("spaceUrl");
        this.user = (String)properties.get(USER_KEY);
        this.password = (String)properties.get(PASSWORD_KEY);
        this.disableServerSideJoins = Boolean.parseBoolean((String)properties.get(DISABLE_SERVER_SIDE_JOINS_KEY));
        this.preferSpaceIterator = Boolean.parseBoolean((String)properties.get(PREFER_SPACE_ITERATOR));
        String timeZoneStr = (String)properties.get("timeZone");
        TimeZone timeZone = timeZoneStr == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneStr);
        this.connectionCalendar = Calendar.getInstance(timeZone);
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isDisableServerSideJoins() {
        return this.disableServerSideJoins;
    }

    public boolean isPreferSpaceIterator() {
        return this.preferSpaceIterator;
    }

    public Calendar getConnectionCalendar() {
        return this.connectionCalendar;
    }
}

