/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.query.QueryResultType;
import com.j_spaces.core.client.SQLQuery;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.util.Util;
import org.apache.commons.lang.StringUtils;

public class InsightEdgeQueryBuilder
implements Serializable {
    public static final Map<String, String> filterWorkarounds = InsightEdgeQueryBuilder.initFilterWorkarounds();
    private String spaceTypeName;
    private String whereClause;
    private List<Object> bindParameters;
    private List<String> projectionFields;
    private SQLQuery<SpaceDocument> query;

    private static Map<String, String> initFilterWorkarounds() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("0 = 1", "rownum = 0");
        result.put("1 = 0", "rownum = 0");
        result.put("0=1", "rownum = 0");
        result.put("1=0", "rownum = 0");
        return result;
    }

    public InsightEdgeQueryBuilder(String spaceTypeName) {
        this.spaceTypeName = spaceTypeName;
    }

    public InsightEdgeQueryBuilder withWhereClause(String whereClause, String addToWhereClause) {
        this.whereClause = InsightEdgeQueryBuilder.filterWhereClause(whereClause);
        if (StringUtils.isNotEmpty((String)addToWhereClause)) {
            this.whereClause = StringUtils.isNotEmpty((String)this.whereClause) ? addToWhereClause + " AND (" + this.whereClause + ")" : addToWhereClause;
        }
        return this;
    }

    public InsightEdgeQueryBuilder withLimitOffset(String limitOffsetClause) {
        if (StringUtils.isNotEmpty((String)limitOffsetClause)) {
            this.whereClause = StringUtils.isNotEmpty((String)this.whereClause) ? "(" + this.whereClause + ") AND " + limitOffsetClause : limitOffsetClause;
        }
        return this;
    }

    public InsightEdgeQueryBuilder withOrder(List<String> order) {
        if (!order.isEmpty()) {
            this.whereClause = this.whereClause + " ORDER BY " + Util.toString(order, (String)"", (String)", ", (String)"");
        }
        return this;
    }

    public InsightEdgeQueryBuilder withBindParameters(List<Object> bindParameters) {
        this.bindParameters = bindParameters;
        return this;
    }

    public InsightEdgeQueryBuilder withProjection(List<String> projectionFields) {
        this.projectionFields = projectionFields;
        return this;
    }

    public SQLQuery<SpaceDocument> build() {
        this.query = new SQLQuery(this.spaceTypeName, this.whereClause, QueryResultType.DOCUMENT);
        for (int i = 0; this.bindParameters != null && i < this.bindParameters.size(); ++i) {
            Object param = this.bindParameters.get(i);
            this.query.setParameter(i + 1, param);
        }
        if (this.projectionFields != null && this.projectionFields.size() > 0) {
            this.query.setProjections(this.projectionFields.toArray(new String[this.projectionFields.size()]));
        }
        return this.query;
    }

    public static String filterWhereClause(String whereClause) {
        if (StringUtils.isNotEmpty((String)whereClause)) {
            for (String key : filterWorkarounds.keySet()) {
                whereClause = whereClause.replace(key, filterWorkarounds.get(key));
            }
        }
        return whereClause;
    }
}

