/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.analytics_xtreme.Layer;
import com.gigaspaces.analytics_xtreme.LayerQueryExecutionReport;
import com.gigaspaces.analytics_xtreme.QueryExecutionReport;
import com.gigaspaces.jdbc.InsightEdgeQueryableContext;
import com.gigaspaces.jdbc.InsightEdgeQueryableJoinContext;
import com.gigaspaces.jdbc.InsightEdgeTable;
import com.gigaspaces.jdbc.analytics_xtreme.AnalyticsXtremeResultsAggregator;
import com.gigaspaces.jdbc.analytics_xtreme.AnalyticsXtremeTableQueryHelper;
import com.gigaspaces.jdbc.exec.JoinQueryExecutor;
import com.gigaspaces.jdbc.exec.SpaceQueryExecutor;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.rel.DynamicParam;
import com.gigaspaces.jdbc.rel.SimpleRexNode;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.AvaticaStatementHelper;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractTableQueryable;

public class InsightEdgeQueryable<T>
extends AbstractTableQueryable<T> {
    private final AnalyticsXtremeTableQueryHelper axQueryHelper;
    private final Clock clock;
    private final String sql;
    private final AnalyticsXtremeResultsAggregator resultsAggregator = new AnalyticsXtremeResultsAggregator();

    InsightEdgeQueryable(QueryProvider queryProvider, SchemaPlus schema, InsightEdgeTable table, String tableName) {
        super(queryProvider, schema, (QueryableTable)table, tableName);
        this.axQueryHelper = AnalyticsXtremeTableQueryHelper.build(table.getSchema().getAnalyticsXtremeConfig(), table.getSpaceTypeName());
        this.clock = Clock.systemDefaultZone();
        Map statementMap = ((AvaticaConnection)queryProvider).statementMap;
        this.sql = statementMap.size() == 1 ? AvaticaStatementHelper.getSignature((AvaticaStatement)((AvaticaStatement)statementMap.get((Object)Integer.valueOf((int)0)))).sql : "N/A";
    }

    public Enumerator<T> enumerator() {
        return null;
    }

    private InsightEdgeTable getTable() {
        return (InsightEdgeTable)this.table;
    }

    public Enumerable<Object> findFlatOrAggregated(DataContext dataContext, List<Map.Entry<String, Class>> fields, List<String> projectionFields, String whereClause, SimpleRexNode whereItems, String limitOffsetClause, List<DynamicParam> dynamicParams, List<String> order, List<String> aggregationCallNames, List<Map.Entry<String, List<String>>> aggregationFunctions, List<String> groups) {
        InsightEdgeQueryableContext context = new InsightEdgeQueryableContext(dataContext, this.getTable(), this.toMap(fields), projectionFields, whereClause, whereItems, limitOffsetClause, dynamicParams, order).setAggregationCallNames(aggregationCallNames).setAggregationFunctions(aggregationFunctions).setGroups(groups);
        return this.axQueryHelper == null ? SpaceQueryExecutor.instance.execute(context) : this.executeAnalyticsXtreme(context);
    }

    private Enumerable<Object> executeAnalyticsXtreme(InsightEdgeQueryableContext context) {
        QueryExecutionReport.Builder reportBuilder = QueryExecutionReport.builder().sql(this.sql).startTime(LocalDateTime.now(this.clock));
        Collection<Layer> layers = this.axQueryHelper.calcRequiredLayers(context);
        ArrayList<Enumerable<Object>> results = new ArrayList<Enumerable<Object>>(layers.size());
        if (layers.size() > 1 && context.getAggregationFunctions() != null && !context.getAggregationFunctions().isEmpty()) {
            context = this.handleAvgAggQuery(context);
        } else if ((context.getAggregationFunctions() == null || context.getAggregationFunctions().isEmpty()) && (context.getProjectionFields() == null || context.getProjectionFields().isEmpty())) {
            context = this.handleSelectAsterisk(context);
        }
        for (Layer layer : layers) {
            this.editWhereClauseForLayers(context, layer);
            LayerQueryExecutionReport.Builder layerReport = LayerQueryExecutionReport.builder().startTime(LocalDateTime.now(this.clock));
            results.add(this.axQueryHelper.getExecutor(layer).execute(context));
            reportBuilder.layerReport(layer, layerReport.setFinishTime(LocalDateTime.now(this.clock)).build());
        }
        Enumerable<Object> result = results.size() == 1 ? (Enumerable<Object>)results.get(0) : this.resultsAggregator.aggregateResults(results, context);
        QueryExecutionReport report = reportBuilder.finishTime(LocalDateTime.now(this.clock)).build();
        this.axQueryHelper.report(report);
        return result;
    }

    private InsightEdgeQueryableContext handleSelectAsterisk(InsightEdgeQueryableContext context) {
        context.setProjectionFields(Collections.list(Collections.enumeration(context.getFields().keySet())));
        return context;
    }

    private void editWhereClauseForLayers(InsightEdgeQueryableContext context, Layer layer) {
        String timeColumn = this.axQueryHelper.getTimeColumn();
        String thresholdValue = this.axQueryHelper.getThresholdString();
        context.setAddToWhereClause(timeColumn + this.getComparatorByLayer(layer) + "'" + thresholdValue + "'");
    }

    private String getComparatorByLayer(Layer layer) {
        switch (layer) {
            case BATCH: {
                return " < ";
            }
            case SPEED: {
                return " >= ";
            }
        }
        return "";
    }

    private InsightEdgeQueryableContext handleAvgAggQuery(InsightEdgeQueryableContext context) {
        ArrayList<Map.Entry<String, List<String>>> aggFuncs = new ArrayList<Map.Entry<String, List<String>>>();
        ArrayList<String> aggCallNames = new ArrayList<String>();
        LinkedHashMap<String, Class> fields = new LinkedHashMap<String, Class>();
        ArrayList<String> projections = new ArrayList<String>();
        List<String> queryFieldNames = context.collectQueryFieldNames();
        block0: for (String queryFieldName : queryFieldNames) {
            if (context.getAggregationCallNames().contains(queryFieldName)) {
                for (int i = 0; i < context.getAggregationFunctions().size(); ++i) {
                    if (!queryFieldName.equals(context.getAggregationCallNames().get(i))) continue;
                    Map.Entry<String, List<String>> entry = context.getAggregationFunctions().get(i);
                    if (entry.getKey().equals("AVG")) {
                        AbstractMap.SimpleEntry<String, List<String>> newSumEntry = new AbstractMap.SimpleEntry<String, List<String>>("SUM", entry.getValue());
                        AbstractMap.SimpleEntry<String, List<String>> newCountEntry = new AbstractMap.SimpleEntry<String, List<String>>("COUNT", entry.getValue());
                        String aggCallName = context.getAggregationCallNames().get(i);
                        aggFuncs.add(newSumEntry);
                        aggCallNames.add("SUM$" + i);
                        fields.put("SUM$" + i, context.getFields().get(aggCallName));
                        projections.add("SUM$" + i);
                        aggFuncs.add(newCountEntry);
                        aggCallNames.add("COUNT$" + i);
                        fields.put("COUNT$" + i, Long.class);
                        projections.add("COUNT$" + i);
                        context.setAvgChangedQuery(true);
                        continue block0;
                    }
                    aggFuncs.add(entry);
                    String aggCallName = context.getAggregationCallNames().get(i);
                    aggCallNames.add(aggCallName);
                    fields.put(aggCallName, context.getFields().get(aggCallName));
                    projections.add(aggCallName);
                    continue block0;
                }
                continue;
            }
            projections.add(queryFieldName);
            fields.put(queryFieldName, context.getFields().get(queryFieldName));
        }
        if (context.isAvgChangedQuery()) {
            context.setOrigAggregationCallNames(context.getAggregationCallNames());
            context.setOrigAggregationFunctions(context.getAggregationFunctions());
            context.setAggregationCallNames(aggCallNames);
            context.setAggregationFunctions(aggFuncs);
            context.setFields(fields);
            context.setProjectionFields(projections);
        }
        return context;
    }

    public Enumerable<Object> findJoin(DataContext dataContext, String joinType, String joinRightTypeName, String rightRoutingField, String leftWhereClause, String rightWhereClause, List<DynamicParam> leftDynamicParams, List<DynamicParam> rightDynamicParams, List<String> leftProjectionFields, List<String> rightProjectionFields, List<String> leftFields, List<String> rightFields, JoinNode joinCondition) {
        InsightEdgeQueryableJoinContext joinContext = new InsightEdgeQueryableJoinContext(dataContext, this.getTable().getInsightEdgeDriverProps(), joinType, this.getTable().getSpaceTypeName(), joinRightTypeName, this.getTable().getRoutingFieldName(), rightRoutingField, leftWhereClause, rightWhereClause, leftDynamicParams, rightDynamicParams, leftProjectionFields, rightProjectionFields, leftFields, rightFields, joinCondition);
        JoinQueryExecutor exec = new JoinQueryExecutor(this.getTable().getSpace());
        return exec.execute(joinContext);
    }

    private Map<String, Class> toMap(List<Map.Entry<String, Class>> fields) {
        LinkedHashMap<String, Class> fieldsMap = new LinkedHashMap<String, Class>();
        for (Map.Entry<String, Class> f : fields) {
            fieldsMap.put(f.getKey(), f.getValue());
        }
        return fieldsMap;
    }
}

