/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.analytics_xtreme.AnalyticsXtremeConfiguration;
import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.InsightEdgeTable;
import com.gigaspaces.jdbc.analytics_xtreme.AnalyticsXtremeTableQueryHelper;
import com.gigaspaces.jdbc.csv.CsvTable;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.SpaceConfigurer;
import org.openspaces.core.space.UrlSpaceConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightEdgeSchema
extends AbstractSchema {
    private static final Logger LOG = LoggerFactory.getLogger(InsightEdgeSchema.class);
    private final InsightEdgeDriverProps insightEdgeDriverProps;
    private AnalyticsXtremeConfiguration axConfig;
    private GigaSpace space;
    private Map<String, Table> tableMap;

    public InsightEdgeSchema(InsightEdgeDriverProps insightEdgeDriverProps) {
        this.insightEdgeDriverProps = insightEdgeDriverProps;
        try {
            String spaceUrl;
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            }
            if ((spaceUrl = insightEdgeDriverProps.getSpaceUrl()) == null) {
                spaceUrl = "jini://*/*/" + insightEdgeDriverProps.getSpaceName();
            }
            LOG.info("Initializing connection to space {}", (Object)spaceUrl);
            UrlSpaceConfigurer configurer = new UrlSpaceConfigurer(spaceUrl);
            if (insightEdgeDriverProps.getUser() != null) {
                configurer.credentials(insightEdgeDriverProps.getUser(), insightEdgeDriverProps.getPassword());
            }
            this.space = new GigaSpaceConfigurer((SpaceConfigurer)configurer).create();
            LOG.debug("Connection to space has been initialized");
        }
        catch (Exception e) {
            LOG.error("Error initializing connection", (Throwable)e);
            throw e;
        }
    }

    public static String trimPackage(String className) {
        return className.substring(className.lastIndexOf(".") + 1, className.length());
    }

    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            LOG.debug("Looking for InsightEdge tables ...");
            this.tableMap = new HashMap<String, Table>();
            List<String> spaceTypes = this.findSpaceRegisteredTypes();
            LOG.trace("Found [{}] space types", (Object)spaceTypes.size());
            for (Map.Entry<String, List<String>> entry : this.mapByShortName(spaceTypes).entrySet()) {
                for (String spaceTypeName : entry.getValue()) {
                    if ("java.lang.Object".equals(spaceTypeName)) continue;
                    SpaceTypeDescriptor typeDescriptor = this.getTypeDescriptor(spaceTypeName);
                    this.registerType(spaceTypeName, typeDescriptor);
                    this.registerType(spaceTypeName.replace('.', '_'), typeDescriptor);
                    if (entry.getValue().size() != 1) continue;
                    this.registerType(entry.getKey(), typeDescriptor);
                }
            }
            if (this.axConfig != null && this.axConfig.isVerbose()) {
                this.tableMap.put("AnalyticsXtremeQueryStats", (Table)new CsvTable(AnalyticsXtremeTableQueryHelper.initCsvFile().toFile()));
            }
        }
        return this.tableMap;
    }

    protected SpaceTypeDescriptor getTypeDescriptor(String spaceTypeName) {
        return this.space.getTypeManager().getTypeDescriptor(spaceTypeName);
    }

    private void registerType(String name, SpaceTypeDescriptor typeDescriptor) {
        if (name.equals(typeDescriptor.getTypeName())) {
            LOG.trace("Registering space type [{}]", (Object)name);
        } else {
            LOG.trace("Registering space type [{}] with alias [{}]", (Object)typeDescriptor.getTypeName(), (Object)name);
        }
        this.tableMap.put(name, (Table)new InsightEdgeTable(name, this.space, typeDescriptor, this));
    }

    protected List<String> findSpaceRegisteredTypes() {
        try {
            IJSpace ijSpace = this.space.getSpace();
            IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin)ijSpace.getAdmin();
            SpaceRuntimeInfo runtimeInfo = admin.getRuntimeInfo();
            List types = runtimeInfo.m_ClassNames;
            LOG.debug("Found registered types in the space {}", (Object)types);
            return types;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to find space registered types", e);
        }
    }

    private Map<String, List<String>> mapByShortName(List<String> spaceTypes) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String spaceType : spaceTypes) {
            String shortName = InsightEdgeSchema.trimPackage(spaceType);
            if (!result.containsKey(shortName)) {
                result.put(shortName, new ArrayList());
            }
            ((List)result.get(shortName)).add(spaceType);
        }
        return result;
    }

    public InsightEdgeDriverProps getDriverProperties() {
        return this.insightEdgeDriverProps;
    }

    public AnalyticsXtremeConfiguration getAnalyticsXtremeConfig() {
        return this.axConfig;
    }

    public void setAnalyticsXtremeConfig(AnalyticsXtremeConfiguration config) {
        this.axConfig = config;
    }

    public GigaSpace getSpace() {
        return this.space;
    }

    public void setSpace(GigaSpace space) {
        this.space = space;
    }
}

