/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.InsightEdgeQueryable;
import com.gigaspaces.jdbc.InsightEdgeSchema;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.gigaspaces.jdbc.rel.InsightEdgeTableScan;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.util.ArrayList;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang3.ClassUtils;
import org.openspaces.core.GigaSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightEdgeTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger LOG = LoggerFactory.getLogger(InsightEdgeTable.class);
    private final String name;
    private final GigaSpace space;
    private final String spaceTypeName;
    private final InsightEdgeSchema schema;
    private boolean metadataInitialized;
    private RelDataType rowType;
    private String routingFieldName;
    private SpaceTypeDescriptor typeDescriptor;

    public InsightEdgeTable(String name, GigaSpace space, SpaceTypeDescriptor typeDescriptor, InsightEdgeSchema schema) {
        super(Object[].class);
        this.name = name;
        this.space = space;
        this.spaceTypeName = typeDescriptor.getTypeName();
        this.schema = schema;
        this.typeDescriptor = typeDescriptor;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new InsightEdgeQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new InsightEdgeTableScan(cluster, cluster.traitSetOf((RelTrait)InsightEdgeRel.CONVENTION), relOptTable, this, null);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (!this.metadataInitialized) {
            try {
                this.findRowType(typeFactory);
            }
            catch (Exception e) {
                LOG.error("Unable to find table row type", (Throwable)e);
            }
            this.metadataInitialized = true;
        }
        return this.rowType;
    }

    private void findRowType(RelDataTypeFactory typeFactory) {
        LOG.debug("Looking for '{}' table row type", (Object)this.spaceTypeName);
        ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>();
        ArrayList<String> tableFieldNames = new ArrayList<String>();
        int propsNum = this.typeDescriptor.getNumOfFixedProperties();
        for (int i = 0; i < propsNum; ++i) {
            SpacePropertyDescriptor propertyDescr = this.typeDescriptor.getFixedProperty(i);
            String name = propertyDescr.getName();
            Class type = propertyDescr.getType();
            if (!this.isSupportedType(type)) continue;
            if (type == String.class) {
                fieldTypes.add(typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR, 65535), true));
            } else {
                fieldTypes.add(typeFactory.createJavaType(type));
            }
            tableFieldNames.add(name);
        }
        ArrayList<String> namesUpperCase = new ArrayList<String>();
        for (String fieldName : tableFieldNames) {
            namesUpperCase.add(fieldName);
        }
        this.rowType = typeFactory.createStructType(Pair.zip(namesUpperCase, fieldTypes));
        LOG.debug("'{}' table row type is {}", (Object)this.spaceTypeName, (Object)this.rowType);
        this.routingFieldName = this.typeDescriptor.getRoutingPropertyName();
        LOG.debug("'{}' table routing field is '{}'", (Object)this.spaceTypeName, (Object)this.routingFieldName);
    }

    private boolean isSupportedType(Class type) {
        return ClassUtils.isPrimitiveOrWrapper((Class)type) || type.getName().startsWith("java.");
    }

    public String getName() {
        return this.name;
    }

    public String getSpaceTypeName() {
        return this.spaceTypeName;
    }

    public GigaSpace getSpace() {
        return this.space;
    }

    public InsightEdgeSchema getSchema() {
        return this.schema;
    }

    public InsightEdgeDriverProps getInsightEdgeDriverProps() {
        return this.schema.getDriverProperties();
    }

    public String getRoutingFieldName() {
        return this.routingFieldName;
    }

    public SpaceTypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }
}

