/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.rel.DynamicParam;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.commons.lang3.RandomStringUtils;

public class Utils
implements Serializable {
    public static Object castToNumberType(Object value, Class targetType) {
        Number valueNum = (Number)value;
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return valueNum.intValue();
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return valueNum.longValue();
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(valueNum.floatValue());
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return valueNum.byteValue();
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return valueNum.doubleValue();
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return valueNum.shortValue();
        }
        throw new IllegalArgumentException("Unexpected type, value = " + value + ", targetType = " + targetType);
    }

    public static Object[] convertSpaceDocToArray(SpaceDocument document, List<String> useFields, Calendar calendar) {
        Object[] arr = new Object[useFields.size()];
        for (int i = 0; i < useFields.size(); ++i) {
            String fieldName = useFields.get(i);
            Object value = document.getProperty(fieldName);
            arr[i] = Utils.adjustValueIfNeeded(value, calendar);
        }
        return arr;
    }

    public static Object adjustValueIfNeeded(Object value, Calendar calendar) {
        if (value == null) {
            return null;
        }
        if (Date.class.equals(value.getClass())) {
            Date date = (Date)value;
            return new Date(Utils.toUtc(date.getTime(), calendar));
        }
        if (java.sql.Date.class.equals(value.getClass())) {
            java.sql.Date date = (java.sql.Date)value;
            return new java.sql.Date(Utils.toUtc(date.getTime(), calendar));
        }
        return value;
    }

    private static long toUtc(long time, Calendar calendar) {
        return time + (long)calendar.getTimeZone().getOffset(time);
    }

    public static Object[] convertEntryToArray(SpaceEntriesAggregatorContext context, List<String> useFields, Calendar calendar) {
        Object[] arr = new Object[useFields.size()];
        for (int i = 0; i < useFields.size(); ++i) {
            String fieldName = useFields.get(i);
            Object value = context.getPathValue(fieldName);
            arr[i] = Utils.adjustValueIfNeeded(value, calendar);
        }
        return arr;
    }

    public static List<Object[]> convertSpaceDocsToArray(List<SpaceDocument> documents, List<String> useFields, Calendar calendar) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(documents.size());
        for (SpaceDocument document : documents) {
            list.add(Utils.convertSpaceDocToArray(document, useFields, calendar));
        }
        return list;
    }

    public static List<Object> getDocumentFields(SpaceDocument doc, List<String> fields) {
        ArrayList<Object> result = new ArrayList<Object>(fields.size());
        for (String field : fields) {
            Object fieldVal = doc.getProperty(field);
            result.add(fieldVal);
        }
        return result;
    }

    public static List<Object> extractDynamicParams(DataContext dataContext, List<DynamicParam> dynamicParamNames, Calendar calendar) {
        ArrayList<Object> dynamicParams = new ArrayList<Object>(dynamicParamNames.size());
        for (DynamicParam dynamicParam : dynamicParamNames) {
            Object paramValue = dataContext.get(dynamicParam.getName());
            dynamicParams.add(Utils.adjustDynamicParamValueIfNeeded(paramValue, dynamicParam.getType(), calendar));
        }
        return dynamicParams;
    }

    private static Object adjustDynamicParamValueIfNeeded(Object paramValue, Class paramType, Calendar calendar) {
        if (java.sql.Date.class.equals((Object)paramType)) {
            return new java.sql.Date(Utils.toMillis(paramValue, calendar));
        }
        if (Date.class.equals((Object)paramType)) {
            return new Date(Utils.toMillis(paramValue, calendar));
        }
        return paramValue;
    }

    private static long toMillis(Object days, Calendar calendar) {
        long millis = ((Number)days).longValue() * 86400000L;
        return Utils.fromUtc(millis, calendar);
    }

    private static long fromUtc(long time, Calendar calendar) {
        return time - (long)calendar.getTimeZone().getOffset(time);
    }

    public static String shortUUID() {
        return RandomStringUtils.random((int)8, (String)"0123456789abcdef");
    }
}

