/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.analytics_xtreme;

import com.gigaspaces.analytics_xtreme.internal.TimeProvider;
import com.gigaspaces.jdbc.InsightEdgeQueryableContext;
import com.gigaspaces.jdbc.rel.SimpleRexNode;
import com.gigaspaces.utils.Pair;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.sql.SqlKind;

public class AnalyticsXtremeQuery {
    private static final int BOTH = 0;
    private static final int SPEED = -1;
    private static final int BATCH = 1;
    private final SimpleRexNode whereItems;
    private final TimeProvider timeProvider;

    public AnalyticsXtremeQuery(InsightEdgeQueryableContext context, TimeProvider timeProvider) {
        this.whereItems = context.getWhereItems();
        this.timeProvider = timeProvider;
    }

    public int compareToThreshold(String column, Instant thresholdValue) {
        if (this.whereItems == null) {
            return 0;
        }
        ArrayList<Pair<SqlKind, Instant>> smallerThanThresholdList = new ArrayList<Pair<SqlKind, Instant>>();
        ArrayList<Pair<SqlKind, Instant>> largerThanThresholdList = new ArrayList<Pair<SqlKind, Instant>>();
        this.getAllThresholdSubTrees(this.whereItems, column, smallerThanThresholdList, largerThanThresholdList, thresholdValue);
        if (smallerThanThresholdList.isEmpty() && largerThanThresholdList.isEmpty() || !smallerThanThresholdList.isEmpty() && !largerThanThresholdList.isEmpty()) {
            return 0;
        }
        if (!smallerThanThresholdList.isEmpty()) {
            HashSet set = new HashSet();
            smallerThanThresholdList.forEach(pair -> set.add(pair.getFirst()));
            if (set.contains(SqlKind.EQUALS) || set.contains(SqlKind.LESS_THAN) || set.contains(SqlKind.LESS_THAN_OR_EQUAL)) {
                return 1;
            }
        } else {
            HashSet set = new HashSet();
            largerThanThresholdList.forEach(pair -> set.add(pair.getFirst()));
            if (set.contains(SqlKind.EQUALS) || set.contains(SqlKind.GREATER_THAN) || set.contains(SqlKind.GREATER_THAN_OR_EQUAL)) {
                return -1;
            }
        }
        return 0;
    }

    private Instant parseQueryParameter(String s) {
        return s.contains("'") ? this.timeProvider.parse(s.replaceAll("['\"]", "")) : Instant.ofEpochMilli(Long.valueOf(s.trim()));
    }

    private void getAllThresholdSubTrees(SimpleRexNode node, String column, List<Pair<SqlKind, Instant>> smallerThanThresholdList, List<Pair<SqlKind, Instant>> largerThanThresholdList, Instant thresholdValue) {
        switch (node.getSqlKind()) {
            case AND: {
                this.getThresholdsFromAnd(node, column, smallerThanThresholdList, largerThanThresholdList, thresholdValue);
                break;
            }
            case OR: {
                break;
            }
            case NOT: {
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LIKE: {
                this.getOneThresholdS(node, column, smallerThanThresholdList, largerThanThresholdList, thresholdValue);
                break;
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                break;
            }
            default: {
                throw new AssertionError((Object)("cannot translate " + node));
            }
        }
    }

    private void getOneThresholdS(SimpleRexNode node, String column, List<Pair<SqlKind, Instant>> smallerThanThresholdList, List<Pair<SqlKind, Instant>> largerThanThresholdList, Instant thresholdValue) {
        Pair pair = new Pair();
        String left = AnalyticsXtremeQuery.getNodeValue(node.getOperands().get(0));
        String right = AnalyticsXtremeQuery.getNodeValue(node.getOperands().get(1));
        if (left.equals(column)) {
            pair.setFirst((Object)node.getSqlKind());
            Instant queryValue = this.parseQueryParameter(right);
            pair.setSecond((Object)queryValue);
            if (thresholdValue.compareTo(queryValue) <= 0) {
                this.addPairToSortedList(largerThanThresholdList, (Pair<SqlKind, Instant>)pair);
            } else {
                this.addPairToSortedList(smallerThanThresholdList, (Pair<SqlKind, Instant>)pair);
            }
        }
    }

    private void addPairToSortedList(List<Pair<SqlKind, Instant>> pairList, Pair<SqlKind, Instant> newPair) {
        int newPairLocation = 0;
        for (int i = 0; i < pairList.size() - 1; ++i) {
            Pair<SqlKind, Instant> currentPair = pairList.get(i);
            Pair<SqlKind, Instant> nextPair = pairList.get(i + 1);
            if (((Instant)currentPair.getSecond()).compareTo((Instant)newPair.getSecond()) <= 0) break;
            if (((Instant)currentPair.getSecond()).compareTo((Instant)newPair.getSecond()) > 0 && ((Instant)nextPair.getSecond()).compareTo((Instant)newPair.getSecond()) <= 0) {
                ++newPairLocation;
                break;
            }
            ++newPairLocation;
        }
        pairList.add(newPairLocation, newPair);
    }

    private void getThresholdsFromAnd(SimpleRexNode node, String column, List<Pair<SqlKind, Instant>> smallerThanThresholdList, List<Pair<SqlKind, Instant>> largerThanThresholdList, Instant thresholdValue) {
        if (node == null) {
            return;
        }
        for (SimpleRexNode operand : node.getOperands()) {
            if (operand == null) continue;
            this.getAllThresholdSubTrees(operand, column, smallerThanThresholdList, largerThanThresholdList, thresholdValue);
        }
    }

    private static String getNodeValue(SimpleRexNode whereItems) {
        if (whereItems == null) {
            return "";
        }
        if (whereItems.getSqlKind().equals((Object)SqlKind.INPUT_REF) || whereItems.getSqlKind().equals((Object)SqlKind.LITERAL)) {
            return whereItems.getValue();
        }
        return "";
    }
}

