/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.analytics_xtreme;

import com.gigaspaces.jdbc.InsightEdgeQueryableContext;
import com.j_spaces.jdbc.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;

public class AnalyticsXtremeResultsAggregator {
    public Enumerable<Object> aggregateResults(List<Enumerable<Object>> results, InsightEdgeQueryableContext context) {
        if (results.isEmpty()) {
            return Linq4j.emptyEnumerable();
        }
        if (!results.get(0).iterator().hasNext()) {
            return results.get(1);
        }
        if (!results.get(1).iterator().hasNext()) {
            return results.get(0);
        }
        List<Map.Entry<String, List<String>>> aggFuncs = context.getAggregationFunctions();
        if (!context.getGroups().isEmpty() && results.size() == 2) {
            List<Object> listResults = this.getGroupedResults(results, context);
            return this.handleLimitResults(listResults, context);
        }
        if (aggFuncs != null && !aggFuncs.isEmpty()) {
            Object[] resultsX = this.convertEnumerableObjToArray(results.get(0));
            Object[] resultsY = this.convertEnumerableObjToArray(results.get(1));
            return this.convertArrayToEnumerable(this.applyAggFunctionOnTwoRows(context, resultsX, resultsY));
        }
        if (!context.getOrder().isEmpty() && results.size() == 2) {
            List<Object> listResults = this.getOrderedResults(results, context);
            return this.handleLimitResults(listResults, context);
        }
        return this.handleLimitResults((Enumerable<Object>)Linq4j.concat(results), context);
    }

    private Enumerable<Object> handleLimitResults(List<Object> listResults, InsightEdgeQueryableContext context) {
        if (context.getLimitOffsetClause() != null && !context.getLimitOffsetClause().isEmpty()) {
            String strLimitValue = context.getLimitOffsetClause().substring(context.getLimitOffsetClause().length() - 1);
            int limitValue = Integer.valueOf(strLimitValue);
            if (listResults.size() >= limitValue) {
                ArrayList<Object> limitedResults = new ArrayList<Object>();
                for (int i = 0; i < limitValue; ++i) {
                    limitedResults.add(listResults.get(i));
                }
                return Linq4j.asEnumerable(limitedResults);
            }
        }
        return Linq4j.asEnumerable(listResults);
    }

    private Enumerable<Object> handleLimitResults(Enumerable<Object> enumResults, InsightEdgeQueryableContext context) {
        if (context.getLimitOffsetClause() != null && !context.getLimitOffsetClause().isEmpty()) {
            String strLimitValue = context.getLimitOffsetClause().substring(context.getLimitOffsetClause().length() - 1);
            int limitValue = Integer.valueOf(strLimitValue);
            ArrayList limitedResults = new ArrayList();
            Iterator iterator = enumResults.iterator();
            while (iterator.hasNext() && limitedResults.size() < limitValue - 1) {
                limitedResults.add(iterator.next());
            }
            return Linq4j.asEnumerable(limitedResults);
        }
        return enumResults;
    }

    private Object[] applyAggFunctionOnTwoRowsForGroupBy(InsightEdgeQueryableContext context, Object[] resultsX, Object[] resultsY) {
        List<String> queryFieldNames = context.collectQueryFieldNames();
        Object[] resultRow = new Object[queryFieldNames.size()];
        int columnCount = queryFieldNames.size();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = queryFieldNames.get(i);
            if (context.getAggregationCallNames().contains(columnName)) {
                int aggIndex = this.getAggIndex(context.getAggregationCallNames(), columnName);
                if (aggIndex == -1) continue;
                String aggName = context.getAggregationFunctions().get(aggIndex).getKey();
                resultRow[i] = this.getCellObject(aggName, resultsX, resultsY, i);
                continue;
            }
            resultRow[i] = resultsX[i];
        }
        if (context.isAvgChangedQuery()) {
            return this.getAvgAggResultsForGroupBy(resultRow, context);
        }
        return resultRow;
    }

    private Object[] applyAggFunctionOnTwoRows(InsightEdgeQueryableContext context, Object[] resultsX, Object[] resultsY) {
        Object[] resultRow = new Object[context.getAggregationFunctions().size()];
        int columnCount = context.getAggregationFunctions().size();
        for (int i = 0; i < columnCount; ++i) {
            String aggName = context.getAggregationFunctions().get(i).getKey();
            resultRow[i] = this.getCellObject(aggName, resultsX, resultsY, i);
        }
        if (context.isAvgChangedQuery()) {
            return this.getAvgAggResults(resultRow, context);
        }
        return resultRow;
    }

    private List<Object> getGroupedResults(List<Enumerable<Object>> results, InsightEdgeQueryableContext context) {
        ArrayList<Object> groupedResults = new ArrayList<Object>();
        HashMap<String, Set<Object[]>> mappedResults = new HashMap<String, Set<Object[]>>();
        for (String group : context.getGroups()) {
            int columnIndex = this.getColumnIndex(context, group);
            if (groupedResults.isEmpty()) {
                List listX = results.get(0).toList();
                List listY = results.get(1).toList();
                this.updateMappedResultsFromList(mappedResults, columnIndex, listX, context);
                this.updateMappedResultsFromList(mappedResults, columnIndex, listY, context);
            } else {
                mappedResults = new HashMap();
                this.updateMappedResultsFromList(mappedResults, columnIndex, groupedResults, context);
                groupedResults.clear();
            }
            if (context.isAvgChangedQuery()) {
                int origRowLength = context.getOrigFields().size();
                for (Set valueSet : mappedResults.values()) {
                    Object[] objects;
                    Object[] newRow = null;
                    Iterator iterator = valueSet.iterator();
                    while (iterator.hasNext() && (objects = (Object[])iterator.next()).length != origRowLength) {
                        newRow = this.getAvgAggResultsForGroupBy(objects, context);
                    }
                    if (newRow != null) {
                        valueSet.clear();
                        valueSet.add(newRow);
                    }
                    groupedResults.addAll(valueSet);
                }
                continue;
            }
            mappedResults.values().forEach(groupedResults::addAll);
        }
        if (context.isAvgChangedQuery()) {
            this.updateContextForAvgAgg(context);
        }
        return groupedResults;
    }

    private int getColumnIndex(InsightEdgeQueryableContext context, String group) {
        int i = 0;
        for (String field : context.getFields().keySet()) {
            if (field.equals(group)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void updateMappedResultsFromList(Map<String, Set<Object[]>> mappedResults, int columnIndex, List<Object> list, InsightEdgeQueryableContext context) {
        for (Object currRow : list) {
            Object[] row = this.toRow(currRow);
            String key = row[columnIndex].toString();
            if (!mappedResults.containsKey(key)) {
                HashSet<Object[]> set = new HashSet<Object[]>();
                set.add(row);
                mappedResults.put(key, set);
                continue;
            }
            Set<Object[]> otherRowSet = mappedResults.get(key);
            mappedResults.put(key, this.mergeRows(row, otherRowSet, context));
        }
    }

    private Set<Object[]> mergeRows(Object[] row, Set<Object[]> rowsSet, InsightEdgeQueryableContext context) {
        if (context.getAggregationFunctions().isEmpty()) {
            boolean shouldNotAddRow = false;
            for (Object[] objRow2 : rowsSet) {
                if (!Arrays.toString(objRow2).equals(Arrays.toString(row))) continue;
                shouldNotAddRow = true;
                break;
            }
            if (!shouldNotAddRow) {
                rowsSet.add(row);
            }
            return rowsSet;
        }
        HashSet<Object[]> newRowsSet = new HashSet<Object[]>();
        rowsSet.forEach(objRow -> newRowsSet.add(this.applyAggFunctionOnTwoRowsForGroupBy(context, row, (Object[])objRow)));
        return newRowsSet;
    }

    private List<Object> getOrderedResults(List<Enumerable<Object>> results, InsightEdgeQueryableContext context) {
        List<orderByColumnObj> orderByColumnLocationList = this.fillOrderByColumnList(context);
        ArrayList<Object> orderedResults = new ArrayList<Object>();
        Iterator iteratorX = results.get(0).iterator();
        Iterator iteratorY = results.get(1).iterator();
        Object[] rowX = null;
        Object[] rowY = null;
        while (iteratorY.hasNext() && iteratorX.hasNext()) {
            int compVal;
            if (rowX == null) {
                rowX = this.toRow(iteratorX.next());
            }
            if (rowY == null) {
                rowY = this.toRow(iteratorY.next());
            }
            if ((compVal = this.compare(rowX, rowY, orderByColumnLocationList)) < 0) {
                orderedResults.add(rowX);
                rowX = null;
                continue;
            }
            if (compVal > 0) {
                orderedResults.add(rowY);
                rowY = null;
                continue;
            }
            orderedResults.add(rowX);
            rowX = null;
            orderedResults.add(rowY);
            rowY = null;
        }
        if (iteratorX.hasNext()) {
            this.dealWithOneIterator(rowX, iteratorX, orderedResults);
        } else {
            this.dealWithOneIterator(rowY, iteratorY, orderedResults);
        }
        return orderedResults;
    }

    private List<orderByColumnObj> fillOrderByColumnList(InsightEdgeQueryableContext context) {
        ArrayList<orderByColumnObj> orderByColumnLocationList = new ArrayList<orderByColumnObj>();
        List<String> queryFieldNames = context.collectQueryFieldNames();
        context.getOrder().forEach(orderBy -> {
            String columnName = orderBy.substring(0, orderBy.indexOf(" "));
            String orderType = orderBy.substring(orderBy.indexOf(" ") + 1);
            orderByColumnLocationList.add(new orderByColumnObj(queryFieldNames.indexOf(columnName), orderType));
        });
        return orderByColumnLocationList;
    }

    private int compare(Object[] rowX, Object[] rowY, List<orderByColumnObj> orderByColumnLocationList) {
        boolean i = false;
        for (orderByColumnObj orderByObj : orderByColumnLocationList) {
            int res = this.getComparedValue(rowX[orderByObj.getIndex()], rowY[orderByObj.getIndex()]);
            if (res == 0) continue;
            if (orderByObj.getOrderType().equals("ASC")) {
                return res;
            }
            return -res;
        }
        return 0;
    }

    private int getComparedValue(Object obj1, Object obj2) {
        Comparable firstComp = (Comparable)obj1;
        Comparable secondComp = (Comparable)obj2;
        return firstComp.compareTo(secondComp);
    }

    private void dealWithOneIterator(Object[] lastRow, Iterator<Object> iterator, List<Object> orderedResults) {
        if (lastRow != null) {
            orderedResults.add(lastRow);
        }
        while (iterator.hasNext()) {
            Object[] row = this.toRow(iterator.next());
            orderedResults.add(row);
        }
    }

    private Object[] toRow(Object obj) {
        Object[] objectArray;
        if (obj instanceof Object[]) {
            objectArray = (Object[])obj;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        return objectArray;
    }

    private Object getCellObject(String aggName, Object[] firstResults, Object[] secondResults, int i) {
        switch (aggName) {
            case "SUM": {
                return this.getSumResult(firstResults, secondResults, i);
            }
            case "MIN": {
                return this.getMinResult(firstResults, secondResults, i);
            }
            case "MAX": {
                return this.getMaxResult(firstResults, secondResults, i);
            }
            case "COUNT": {
                return this.getCountResult(firstResults, secondResults, i);
            }
        }
        throw new UnsupportedOperationException("Aggregation support is under construction");
    }

    private Object[] getAvgAggResults(Object[] resultRow, InsightEdgeQueryableContext context) {
        Object[] newResultRow = new Object[context.getOrigAggregationFunctions().size()];
        int j = 0;
        for (int i = 0; i < context.getOrigAggregationFunctions().size(); ++i) {
            Map.Entry<String, List<String>> entry = context.getOrigAggregationFunctions().get(i);
            if (entry.getKey().equals("AVG")) {
                newResultRow[i] = this.getDivideForAvg(resultRow, context, j, i);
                j += 2;
                continue;
            }
            newResultRow[i] = resultRow[j];
            ++j;
        }
        this.updateContextForAvgAgg(context);
        return newResultRow;
    }

    private Number getDivideForAvg(Object[] resultRow, InsightEdgeQueryableContext context, int newAggIndex, int origAggIndex) {
        Number divisor;
        double divisorAsDouble;
        if (resultRow[newAggIndex] != null && resultRow[newAggIndex + 1] != null && (divisorAsDouble = (divisor = this.getNumberObject(resultRow[newAggIndex + 1])).doubleValue()) != 0.0) {
            return NumberUtil.divide((Number)this.getNumberObject(resultRow[newAggIndex]), (Number)divisor, (String)context.getOrigFields().get(context.getOrigAggregationCallNames().get(origAggIndex)).getName());
        }
        return null;
    }

    private Object[] getAvgAggResultsForGroupBy(Object[] resultRow, InsightEdgeQueryableContext context) {
        Object[] newResultRow = new Object[context.getOrigFields().size()];
        int origAggIndex = 0;
        int aggIndex = 0;
        int resultsIndex = 0;
        List<String> queryFieldNames = context.collectQueryFieldNames();
        for (int i = 0; i < context.getOrigFields().size(); ++i) {
            String columnName = queryFieldNames.get(resultsIndex);
            if (context.getAggregationCallNames().contains(columnName) && context.getAggregationCallNames().get(aggIndex).equals(columnName)) {
                String aggName = context.getOrigAggregationFunctions().get(origAggIndex).getKey();
                if (aggName.equals("AVG")) {
                    newResultRow[i] = this.getDivideForAvg(resultRow, context, aggIndex, origAggIndex);
                    aggIndex += 2;
                    ++resultsIndex;
                } else {
                    newResultRow[i] = resultRow[resultsIndex];
                }
            } else {
                newResultRow[i] = resultRow[resultsIndex];
            }
            ++resultsIndex;
        }
        return newResultRow;
    }

    private void updateContextForAvgAgg(InsightEdgeQueryableContext context) {
        context.setAggregationCallNames(context.getOrigAggregationCallNames());
        context.setAggregationFunctions(context.getOrigAggregationFunctions());
        context.setFields(context.getOrigFields());
        context.setProjectionFields(context.getOrigProjectionFields());
    }

    private int getAggIndex(List<String> aggList, String columnName) {
        for (int i = 0; i < aggList.size(); ++i) {
            if (!aggList.get(i).equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    private Enumerable<Object> convertArrayToEnumerable(Object[] resultRow) {
        LinkedList<Object> objectsList = new LinkedList<Object>();
        if (resultRow.length == 1) {
            objectsList.add(resultRow[0]);
        } else {
            objectsList.add(resultRow);
        }
        return Linq4j.asEnumerable(objectsList);
    }

    private Object getMaxResult(Object[] firstResults, Object[] secondResults, int i) {
        Comparable comparableResult2;
        Comparable comparableResult1 = firstResults.length > i && firstResults[i] != null ? this.getComparableObject(firstResults[i]) : null;
        Comparable comparable = comparableResult2 = secondResults.length > i && secondResults[i] != null ? this.getComparableObject(secondResults[i]) : null;
        if (comparableResult1 == null) {
            return comparableResult2;
        }
        if (comparableResult2 == null || comparableResult1.compareTo(comparableResult2) > 0) {
            return comparableResult1;
        }
        return comparableResult2;
    }

    private Object getMinResult(Object[] firstResults, Object[] secondResults, int i) {
        Comparable comparableResult2;
        Comparable comparableResult1 = firstResults.length > i && firstResults[i] != null ? this.getComparableObject(firstResults[i]) : null;
        Comparable comparable = comparableResult2 = secondResults.length > i && secondResults[i] != null ? this.getComparableObject(secondResults[i]) : null;
        if (comparableResult2 == null) {
            return comparableResult1;
        }
        if (comparableResult1 == null || comparableResult1.compareTo(comparableResult2) > 0) {
            return comparableResult2;
        }
        return comparableResult1;
    }

    private Object getSumResult(Object[] firstResults, Object[] secondResults, int i) {
        Integer numberResult1 = firstResults.length > i && firstResults[i] != null ? (Number)this.getNumberObject(firstResults[i]) : (Number)0;
        Integer numberResult2 = secondResults.length > i && secondResults[i] != null ? (Number)this.getNumberObject(secondResults[i]) : (Number)0;
        return NumberUtil.add((Number)numberResult1, (Number)numberResult2, (String)numberResult1.getClass().getName());
    }

    private Object getCountResult(Object[] firstResults, Object[] secondResults, int i) {
        Long longResult1 = firstResults.length > 0 ? (Long)firstResults[i] : 0L;
        Long longResult2 = secondResults.length > 0 ? (Long)secondResults[i] : 0L;
        return longResult1 + longResult2;
    }

    private Object[] convertEnumerableObjToArray(Enumerable<Object> enumerable) {
        Object obj = enumerable.first();
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        if (obj != null) {
            return new Object[]{obj};
        }
        return new Object[0];
    }

    private Number getNumberObject(Object obj) {
        if (obj instanceof Number) {
            return (Number)obj;
        }
        throw new IllegalStateException("Not a number column type " + obj);
    }

    private Comparable getComparableObject(Object object) {
        if (object instanceof Comparable) {
            return (Comparable)object;
        }
        throw new IllegalStateException("Not a comparable column type " + object);
    }

    private class orderByColumnObj {
        int index;
        String orderType;

        public orderByColumnObj(int index, String orderType) {
            this.index = index;
            this.orderType = orderType;
        }

        public int getIndex() {
            return this.index;
        }

        public String getOrderType() {
            return this.orderType;
        }
    }
}

