/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.analytics_xtreme;

import com.gigaspaces.analytics_xtreme.AnalyticsXtremeConfiguration;
import com.gigaspaces.analytics_xtreme.DataLifecyclePolicy;
import com.gigaspaces.analytics_xtreme.Layer;
import com.gigaspaces.analytics_xtreme.QueryExecutionReport;
import com.gigaspaces.analytics_xtreme.internal.TimeProvider;
import com.gigaspaces.jdbc.InsightEdgeQueryableContext;
import com.gigaspaces.jdbc.analytics_xtreme.AnalyticsXtremeQuery;
import com.gigaspaces.jdbc.exec.BatchQueryExecutor;
import com.gigaspaces.jdbc.exec.InsightEdgeQueryExecutor;
import com.gigaspaces.jdbc.exec.SpaceQueryExecutor;
import com.gigaspaces.start.SystemInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnalyticsXtremeTableQueryHelper {
    private final Logger logger = Logger.getLogger("com.gigaspaces.jdbc.AnalyticsXtreme");
    private static final Collection<Layer> speedOnly = Collections.singleton(Layer.SPEED);
    private static final Collection<Layer> batchOnly = Collections.singleton(Layer.BATCH);
    private static final Collection<Layer> speedAndBatch = Arrays.asList(Layer.SPEED, Layer.BATCH);
    private final AnalyticsXtremeConfiguration configuration;
    private final Instant thresholdInstant;
    private final String timeColumn;
    private final TimeProvider timeProvider;
    private final InsightEdgeQueryExecutor batchQueryExecutor;
    private final Path reportLogPath;
    private final Path reportCsvPath;

    private AnalyticsXtremeTableQueryHelper(AnalyticsXtremeConfiguration configuration, DataLifecyclePolicy tablePolicy) {
        this.configuration = configuration;
        this.timeColumn = tablePolicy.getTimeColumn();
        this.timeProvider = TimeProvider.of((String)tablePolicy.getTimeFormat());
        this.batchQueryExecutor = new BatchQueryExecutor(tablePolicy.getBatchDataSource());
        this.thresholdInstant = AnalyticsXtremeTableQueryHelper.initThresholdInstant(tablePolicy, this.timeProvider);
        this.reportLogPath = configuration.isVerbose() ? Paths.get(SystemInfo.singleton().getXapHome(), "logs", "analytics_xtreme.log") : null;
        Path path = this.reportCsvPath = configuration.isVerbose() ? Paths.get(SystemInfo.singleton().getXapHome(), "logs", "analytics_xtreme.csv") : null;
        if (configuration.isVerbose()) {
            this.logger.setLevel(Level.FINEST);
        }
    }

    private static Instant initThresholdInstant(DataLifecyclePolicy tablePolicy, TimeProvider timeProvider) {
        String accelerationPeriod = tablePolicy.getSpeedPeriod();
        Duration accelerationDuration = accelerationPeriod.toUpperCase().startsWith("P") ? Duration.parse(accelerationPeriod) : null;
        return accelerationDuration != null ? Clock.systemUTC().instant().minus(accelerationDuration) : timeProvider.parse(accelerationPeriod);
    }

    public static AnalyticsXtremeTableQueryHelper build(AnalyticsXtremeConfiguration config, String typeName) {
        DataLifecyclePolicy policy = config != null ? config.getPolicy(typeName) : null;
        return policy != null ? new AnalyticsXtremeTableQueryHelper(config, policy) : null;
    }

    public static Path initCsvFile() {
        Path path = Paths.get(SystemInfo.singleton().getXapHome(), "logs", "analytics_xtreme.csv");
        if (!path.toFile().exists()) {
            AnalyticsXtremeTableQueryHelper.appendLine(path, "startTime:timestamp,startTimeNumeric:long,duration:int,speedDuration:int,batchDuration:int,query:string" + System.lineSeparator());
        }
        return path;
    }

    public Collection<Layer> calcRequiredLayers(InsightEdgeQueryableContext context) {
        AnalyticsXtremeQuery query = new AnalyticsXtremeQuery(context, this.timeProvider);
        int result = query.compareToThreshold(this.timeColumn, this.thresholdInstant);
        if (result < 0) {
            return speedOnly;
        }
        if (result > 0) {
            return batchOnly;
        }
        return speedAndBatch;
    }

    public String getThresholdString() {
        return this.timeProvider.format(this.thresholdInstant);
    }

    public InsightEdgeQueryExecutor getExecutor(Layer layer) {
        switch (layer) {
            case SPEED: {
                return SpaceQueryExecutor.instance;
            }
            case BATCH: {
                return this.batchQueryExecutor;
            }
        }
        throw new IllegalStateException("Unsupported layer " + layer);
    }

    public void report(QueryExecutionReport report) {
        String reportStr = null;
        if (this.logger.isLoggable(Level.FINE)) {
            reportStr = report.toString();
            this.logger.fine("Query execution report: " + reportStr + " || sql: " + report.getSql());
        }
        if (this.reportLogPath != null) {
            if (reportStr == null) {
                reportStr = report.toString();
            }
            AnalyticsXtremeTableQueryHelper.appendLine(this.reportLogPath, reportStr + System.lineSeparator());
        }
        if (this.reportCsvPath != null) {
            long speedDuration = report.getSpeedLayerReport() != null ? report.getSpeedLayerReport().getDuration().toMillis() : 0L;
            long batchDuration = report.getBatchLayerReport() != null ? report.getBatchLayerReport().getDuration().toMillis() : 0L;
            DateTimeFormatter csvFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String line = String.format("%s,%d,%d,%d,%d,%s%n", report.getStartTime().format(csvFormatter), report.getStartTime().toInstant(ZoneOffset.UTC).toEpochMilli(), report.getExecutionDuration().toMillis(), speedDuration, batchDuration, '\"' + report.getSql() + '\"');
            AnalyticsXtremeTableQueryHelper.appendLine(this.reportCsvPath, line);
        }
        if (this.configuration.getListener() != null) {
            this.configuration.getListener().accept(report);
        }
    }

    private static void appendLine(Path path, String line) {
        try {
            Files.write(path, line.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }
}

