/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec;

import com.gigaspaces.analytics_xtreme.spi.BatchDataSource;
import com.gigaspaces.jdbc.InsightEdgeQueryableContext;
import com.gigaspaces.jdbc.exec.InsightEdgeQueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;

public class BatchQueryExecutor
implements InsightEdgeQueryExecutor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final BatchDataSource dataSource;

    public BatchQueryExecutor(BatchDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Enumerable<Object> executeQuery(InsightEdgeQueryableContext context) {
        return this.getEnumerableObjectsFromQuery(context);
    }

    private Enumerable<Object> getEnumerableObjectsFromQuery(InsightEdgeQueryableContext context) {
        Set<Object> collectionResults;
        String sql = this.toSql(context);
        this.logger.fine("Query: " + sql);
        Collection<Object> results = collectionResults = this.dataSource.query(sql, context.getTable().getName());
        if (collectionResults.size() == 1) {
            Object[] singleRow = (Object[])collectionResults.iterator().next();
            if (singleRow.length == 1) {
                Object object = singleRow[0];
                results = Collections.singleton(object);
            }
        } else if (collectionResults.size() > 1 && context.collectQueryFieldNames().size() == 1) {
            ArrayList objectCollection = new ArrayList();
            collectionResults.forEach(objArray -> objectCollection.add(objArray[0]));
            results = objectCollection;
        }
        return Linq4j.asEnumerable((Collection)results);
    }

    @Override
    public Enumerable<Object> executeAggregation(InsightEdgeQueryableContext context) {
        String sql = this.toSql(context);
        this.logger.fine("Aggregation query: " + sql);
        return this.getEnumerableObjectsFromQuery(context);
    }

    private String toSql(InsightEdgeQueryableContext context) {
        String projection = this.getProjection(context);
        String type = context.getTable().getName();
        String whereClause = context.getWhereClause().isEmpty() ? " WHERE " + context.getAddToWhereClause() : " WHERE " + context.getAddToWhereClause() + " AND (" + context.getWhereClause() + ")";
        String limitClause = "";
        if (context.getLimitOffsetClause() != null && !context.getLimitOffsetClause().isEmpty()) {
            String strLimitValue = context.getLimitOffsetClause().substring(context.getLimitOffsetClause().length() - 1);
            int limitValue = Integer.valueOf(strLimitValue) - 1;
            limitClause = " LIMIT " + limitValue;
        }
        String orderByPart = context.getOrder().isEmpty() ? "" : " ORDER BY " + String.join((CharSequence)",", context.getOrder());
        String groupByPart = context.getGroups().isEmpty() ? "" : " GROUP BY " + String.join((CharSequence)",", context.getGroups());
        return "SELECT " + projection + " FROM " + type + whereClause + groupByPart + orderByPart + limitClause;
    }

    private String getProjection(InsightEdgeQueryableContext context) {
        LinkedList<String> stringList = new LinkedList<String>();
        List<Map.Entry<String, List<String>>> aggFuncs = context.getAggregationFunctions();
        List<String> queryFieldNames = context.collectQueryFieldNames();
        String autoGeneratedIdColumnName = "";
        if (context.getTable().getTypeDescriptor().isAutoGenerateId()) {
            autoGeneratedIdColumnName = context.getTable().getTypeDescriptor().getIdPropertyName();
        }
        block0: for (String queryFieldName : queryFieldNames) {
            if (queryFieldName.equals(autoGeneratedIdColumnName)) {
                stringList.add("'' AS " + queryFieldName);
                continue;
            }
            if (context.getAggregationCallNames().contains(queryFieldName)) {
                for (int i = 0; i < context.getAggregationFunctions().size(); ++i) {
                    if (!queryFieldName.equals(context.getAggregationCallNames().get(i))) continue;
                    Map.Entry<String, List<String>> entry = aggFuncs.get(i);
                    List<String> aggArgs = entry.getValue();
                    String argValue = aggArgs.size() == 0 ? "*" : entry.getValue().get(0);
                    String aggProj = entry.getKey() + "(" + argValue + ")";
                    if (entry.getKey().equalsIgnoreCase("AVG")) {
                        String aggColumnType = this.getCastAggColumnType(context.getFields().get(context.getAggregationCallNames().get(i)).getName());
                        String castProj = "CAST(" + aggProj + " AS " + aggColumnType + " )";
                        stringList.add(castProj);
                        continue block0;
                    }
                    stringList.add(aggProj);
                    continue block0;
                }
                continue;
            }
            stringList.add(queryFieldName);
        }
        if (stringList.isEmpty()) {
            stringList.add("*");
        }
        return String.join((CharSequence)",", stringList);
    }

    private String getCastAggColumnType(String aggColumnType) {
        try {
            return Class.forName(aggColumnType).getField("TYPE").get(null).toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            this.logger.warning(e.getMessage());
            return aggColumnType;
        }
    }
}

