/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.InsightEdgeQueryBuilder;
import com.gigaspaces.jdbc.InsightEdgeQueryableJoinContext;
import com.gigaspaces.jdbc.Utils;
import com.gigaspaces.jdbc.exec.join.DistributedJoinTask;
import com.gigaspaces.jdbc.exec.join.JoinArgs;
import com.gigaspaces.jdbc.exec.join.JoinResult;
import com.gigaspaces.jdbc.exec.join.JoinTrait;
import com.gigaspaces.jdbc.exec.join.JoinedRows;
import com.gigaspaces.jdbc.exec.join.condition.JoinCollocationChecker;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqualityConjunctionChecker;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.sql.JoinType;
import org.apache.commons.lang.ArrayUtils;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.extensions.QueryExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(JoinQueryExecutor.class);
    private GigaSpace space;

    public JoinQueryExecutor(GigaSpace space) {
        this.space = space;
    }

    public Enumerable<Object> execute(InsightEdgeQueryableJoinContext context) {
        JoinResult taskResult;
        HashSet<JoinTrait> joinTraits = new HashSet<JoinTrait>();
        if (JoinEqualityConjunctionChecker.isEqualityConjunction(context.getJoinCondition())) {
            joinTraits.add(JoinTrait.EQUALITY_CONJUNCTION);
        }
        if (JoinCollocationChecker.isCollocatedJoin(context.getJoinCondition(), context.getLeftRoutingField(), context.getRightRoutingField())) {
            joinTraits.add(JoinTrait.COLLOCATED_JOIN);
        }
        List<Object> leftDynamicParams = Utils.extractDynamicParams(context.getDataContext(), context.getLeftDynamicParamNames(), context.getDriverProps().getConnectionCalendar());
        List<Object> rightDynamicParams = Utils.extractDynamicParams(context.getDataContext(), context.getRightDynamicParamNames(), context.getDriverProps().getConnectionCalendar());
        JoinType joinType = JoinType.valueOf((String)context.getJoinTypeString());
        Long leftRowCount = this.countTableRowsIfNeeded(context.getJoinLeftTypeName(), context.getLeftWhereClause(), leftDynamicParams, joinType);
        Long rightRowCount = this.countTableRowsIfNeeded(context.getJoinRightTypeName(), context.getRightWhereClause(), rightDynamicParams, joinType);
        JoinArgs joinArgs = new JoinArgs(joinType, joinTraits, new JoinArgs.Relation(context.getJoinLeftTypeName(), context.getLeftWhereClause(), leftDynamicParams, context.getLeftProjectionFields(), context.getLeftFields(), leftRowCount), new JoinArgs.Relation(context.getJoinRightTypeName(), context.getRightWhereClause(), rightDynamicParams, context.getRightProjectionFields(), context.getRightFields(), rightRowCount), context.getJoinCondition());
        try {
            String taskId = Utils.shortUUID();
            LOG.debug("Executing Distributed JOIN task {}: {}", (Object)taskId, (Object)joinArgs);
            taskResult = (JoinResult)this.space.execute((DistributedTask)new DistributedJoinTask(joinArgs, taskId, context.getDriverProps())).get();
            LOG.debug("Finished Distributed JOIN task {}, with result count {}", (Object)taskId, (Object)taskResult.getJoinedRows().size());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute distributed join task " + joinArgs, e);
        }
        List<JoinedRows> joinedRows = taskResult.getJoinedRows();
        Object[] arrayOfNulls = this.createArrayOfNulls(joinType, context.getLeftFields(), context.getRightFields());
        ArrayList<Object[]> result = new ArrayList<Object[]>(joinedRows.size());
        for (JoinedRows joinedRow : joinedRows) {
            Object[] firstValues = joinedRow.getFirst();
            List<Object[]> secondRows = joinedRow.getSecond();
            if (secondRows.size() > 0) {
                for (Object[] secondValues : secondRows) {
                    Object[] row = this.combineJoinSides(firstValues, secondValues, joinType, leftRowCount, rightRowCount);
                    result.add(row);
                }
                continue;
            }
            Object[] row = this.combineJoinSides(firstValues, arrayOfNulls, joinType, leftRowCount, rightRowCount);
            result.add(row);
        }
        return Linq4j.asEnumerable(result);
    }

    private Long countTableRowsIfNeeded(String typeName, String whereClause, List<Object> dynamicParams, JoinType joinType) {
        if (joinType == JoinType.INNER) {
            SQLQuery<SpaceDocument> query = new InsightEdgeQueryBuilder(typeName).withWhereClause(whereClause, null).withBindParameters(dynamicParams).build();
            String queryId = Utils.shortUUID();
            LOG.debug("Executing count query {}: {}", (Object)queryId, query);
            long count = QueryExtension.count((GigaSpace)this.space, query, (String)"*");
            LOG.debug("Finished count query {}", (Object)queryId);
            return count;
        }
        return null;
    }

    private Object[] createArrayOfNulls(JoinType joinType, List<String> leftFields, List<String> rightFields) {
        int nullsCount;
        switch (joinType) {
            case INNER: 
            case LEFT: {
                nullsCount = rightFields.size();
                break;
            }
            case RIGHT: {
                nullsCount = leftFields.size();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported join type " + joinType);
            }
        }
        return new Object[nullsCount];
    }

    private Object[] combineJoinSides(Object[] firstValues, Object[] secondValues, JoinType joinType, Long leftRowCount, Long rightRowCount) {
        switch (joinType) {
            case INNER: {
                if (leftRowCount < rightRowCount) {
                    return ArrayUtils.addAll((Object[])secondValues, (Object[])firstValues);
                }
                return ArrayUtils.addAll((Object[])firstValues, (Object[])secondValues);
            }
            case LEFT: {
                return ArrayUtils.addAll((Object[])firstValues, (Object[])secondValues);
            }
            case RIGHT: {
                return ArrayUtils.addAll((Object[])secondValues, (Object[])firstValues);
            }
        }
        throw new RuntimeException("Unsupported join type " + joinType);
    }
}

