/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec;

import com.gigaspaces.client.iterator.SpaceIterator;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.InsightEdgeQueryBuilder;
import com.gigaspaces.jdbc.InsightEdgeQueryableContext;
import com.gigaspaces.jdbc.Utils;
import com.gigaspaces.jdbc.exec.InsightEdgeQueryExecutor;
import com.gigaspaces.query.aggregators.GroupByAggregator;
import com.gigaspaces.query.aggregators.GroupByResult;
import com.gigaspaces.query.aggregators.GroupByValue;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.openspaces.core.GigaSpace;
import org.openspaces.extensions.QueryExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceQueryExecutor
implements InsightEdgeQueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceQueryExecutor.class);
    public static final SpaceQueryExecutor instance = new SpaceQueryExecutor();

    private SpaceQueryExecutor() {
    }

    @Override
    public Enumerable<Object> executeQuery(InsightEdgeQueryableContext context) {
        InsightEdgeDriverProps driverProps = context.getTable().getInsightEdgeDriverProps();
        SQLQuery<SpaceDocument> query = new InsightEdgeQueryBuilder(context.getTable().getSpaceTypeName()).withWhereClause(context.getWhereClause(), context.getAddToWhereClause()).withLimitOffset(context.getLimitOffsetClause()).withOrder(context.getOrder()).withBindParameters(Utils.extractDynamicParams(context.getDataContext(), context.getDynamicParams(), driverProps.getConnectionCalendar())).withProjection(context.getProjectionFields()).build();
        LOG.debug("Executing XAP query: {} Projection: {} Parameters: {}", new Object[]{query, Arrays.toString(query.getProjections()), Arrays.toString(query.getParameters())});
        Map<String, Class> fields = context.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        for (Map.Entry<String, Class> field : fields.entrySet()) {
            fieldNames.add(field.getKey());
        }
        boolean useSpaceIterator = driverProps.isPreferSpaceIterator() && context.getOrder().isEmpty();
        GigaSpace space = context.getTable().getSpace();
        LOG.info("Querying space {}", (Object)space.getName());
        if (useSpaceIterator) {
            SpaceIterator items = space.iterator(query);
            final ConvertingIterator convertingIterator = new ConvertingIterator((Iterator<SpaceDocument>)items, fieldNames, driverProps.getConnectionCalendar());
            Iterable<Object> iterable = new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return convertingIterator;
                }
            };
            return Linq4j.asEnumerable((Iterable)iterable);
        }
        SpaceDocument[] queryResultArray = (SpaceDocument[])space.readMultiple(query);
        ArrayList<Object> scanResult = new ArrayList<Object>();
        for (SpaceDocument spaceDoc : queryResultArray) {
            Object resultObject = this.convertSpaceDocumentToResultObject(spaceDoc, fieldNames, driverProps.getConnectionCalendar());
            scanResult.add(resultObject);
        }
        return Linq4j.asEnumerable(scanResult);
    }

    @Override
    public Enumerable<Object> executeAggregation(InsightEdgeQueryableContext context) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing aggregation: " + System.lineSeparator() + "    dataContext={}; " + System.lineSeparator() + "    spaceTypeName={}; " + System.lineSeparator() + "    fields={}, " + System.lineSeparator() + "    projectionFields={}, " + System.lineSeparator() + "    whereClause={}, " + System.lineSeparator() + "    limitOffsetClause={}; " + System.lineSeparator() + "    dynamicParamNames={}; " + System.lineSeparator() + "    order={}; " + System.lineSeparator() + "    aggregationCallNames={}; " + System.lineSeparator() + "    aggregationFunctions={}; " + System.lineSeparator() + "    groups={}", new Object[]{context.getDataContext(), context.getTable().getSpaceTypeName(), context.getFields(), context.getProjectionFields(), context.getWhereClause(), context.getLimitOffsetClause(), context.getDynamicParams(), context.getOrder(), context.getAggregationCallNames(), context.getAggregationFunctions(), context.getGroups()});
        }
        InsightEdgeDriverProps driverProps = context.getTable().getInsightEdgeDriverProps();
        SQLQuery<SpaceDocument> query = new InsightEdgeQueryBuilder(context.getTable().getSpaceTypeName()).withWhereClause(context.getWhereClause(), context.getAddToWhereClause()).withLimitOffset(context.getLimitOffsetClause()).withOrder(context.getOrder()).withBindParameters(Utils.extractDynamicParams(context.getDataContext(), context.getDynamicParams(), driverProps.getConnectionCalendar())).withProjection(context.getProjectionFields()).build();
        GroupByAggregator groupByAggregator = new GroupByAggregator();
        List<Map.Entry<String, List<String>>> aggFuncs = context.getAggregationFunctions();
        List<SpaceEntriesAggregator> spaceAggs = aggFuncs != null && !aggFuncs.isEmpty() ? this.buildSpaceAggregators(aggFuncs) : Collections.singletonList(QueryExtension.count());
        groupByAggregator.select(spaceAggs.toArray(new SpaceEntriesAggregator[0]));
        groupByAggregator.groupBy(context.getGroups().toArray(new String[0]));
        String queryId = Utils.shortUUID();
        LOG.debug("Executing InsightEdge aggregated query {}: {}", (Object)queryId, query);
        GroupByResult groupByResult = QueryExtension.groupBy((GigaSpace)context.getTable().getSpace(), query, (GroupByAggregator)groupByAggregator);
        LOG.debug("Finished query {}", (Object)queryId);
        List<String> queryFieldNames = context.collectQueryFieldNames();
        List<Object> result = this.buildResultList(driverProps, groupByResult, context.getFields(), context.getAggregationCallNames(), context.getAggregationFunctions(), context.getGroups(), queryFieldNames);
        this.logResultIfNeeded(result, queryId);
        return Linq4j.asEnumerable(result);
    }

    private Object convertSpaceDocumentToResultObject(SpaceDocument spaceDoc, List<String> fieldNames, Calendar calendar) {
        Object[] fieldValues = Utils.convertSpaceDocToArray(spaceDoc, fieldNames, calendar);
        if (fieldValues.length == 1) {
            return fieldValues[0];
        }
        return fieldValues;
    }

    private List<SpaceEntriesAggregator> buildSpaceAggregators(List<Map.Entry<String, List<String>>> aggregationFunctions) {
        ArrayList<SpaceEntriesAggregator> spaceAggs = new ArrayList<SpaceEntriesAggregator>();
        for (Map.Entry<String, List<String>> agg : aggregationFunctions) {
            String aggName = agg.getKey();
            List<String> aggArgs = agg.getValue();
            switch (aggName) {
                case "SUM": {
                    String field = aggArgs.get(0);
                    spaceAggs.add(QueryExtension.sum((String)field));
                    break;
                }
                case "MIN": {
                    String field = aggArgs.get(0);
                    spaceAggs.add(QueryExtension.min((String)field));
                    break;
                }
                case "MAX": {
                    String field = aggArgs.get(0);
                    spaceAggs.add(QueryExtension.max((String)field));
                    break;
                }
                case "COUNT": {
                    if (aggArgs.size() == 0) {
                        spaceAggs.add(QueryExtension.count());
                        break;
                    }
                    String field = aggArgs.get(0);
                    spaceAggs.add(QueryExtension.count((String)field));
                    break;
                }
                case "AVG": {
                    String field = aggArgs.get(0);
                    spaceAggs.add(QueryExtension.average((String)field));
                }
            }
        }
        return spaceAggs;
    }

    private List<Object> buildResultList(InsightEdgeDriverProps driverProps, GroupByResult groupByResult, Map<String, Class> fields, List<String> aggregationCallNames, List<Map.Entry<String, List<String>>> aggregationFunctions, List<String> groups, List<String> queryFieldNames) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, Object> keyedRow = new HashMap<String, Object>();
        for (GroupByValue groupByValue : groupByResult) {
            int i;
            for (i = 0; i < groups.size(); ++i) {
                keyedRow.put(groups.get(i), groupByValue.getKey().get(i));
            }
            for (i = 0; i < aggregationFunctions.size(); ++i) {
                Object value = groupByValue.get(i);
                String name = aggregationCallNames.get(i);
                Class expectedType = fields.get(name);
                Object castedValue = this.castToExpectedReturnType(value, expectedType);
                keyedRow.put(name, castedValue);
            }
            Object[] returnRow = new Object[queryFieldNames.size()];
            for (int i2 = 0; i2 < queryFieldNames.size(); ++i2) {
                String queryFieldName = queryFieldNames.get(i2);
                Object value = keyedRow.get(queryFieldName);
                returnRow[i2] = Utils.adjustValueIfNeeded(value, driverProps.getConnectionCalendar());
            }
            if (returnRow.length == 1) {
                result.add(returnRow[0]);
                continue;
            }
            result.add(returnRow);
        }
        return result;
    }

    private void logResultIfNeeded(List<Object> result, String queryId) {
        if (LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Object item : result) {
                sb.append(System.lineSeparator());
                if (item instanceof Object[]) {
                    sb.append(Arrays.toString((Object[])item));
                    continue;
                }
                sb.append(item);
            }
            LOG.trace("Aggregated result {}: {}", (Object)queryId, (Object)sb);
        }
    }

    private Object castToExpectedReturnType(Object value, Class expectedType) {
        if (value.getClass() == expectedType) {
            return value;
        }
        return Utils.castToNumberType(value, expectedType);
    }

    class ConvertingIterator
    implements Iterator<Object> {
        Iterator<SpaceDocument> iterator;
        List<String> fieldNames;
        private Calendar connectionCalendar;

        public ConvertingIterator(Iterator<SpaceDocument> iterator, List<String> fieldNames, Calendar connectionCalendar) {
            this.iterator = iterator;
            this.fieldNames = fieldNames;
            this.connectionCalendar = connectionCalendar;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            SpaceDocument next = this.iterator.next();
            return SpaceQueryExecutor.this.convertSpaceDocumentToResultObject(next, this.fieldNames, this.connectionCalendar);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

