/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.exec.join.JoinArgs;
import com.gigaspaces.jdbc.exec.join.JoinResult;
import com.gigaspaces.jdbc.exec.join.JoinTrait;
import com.gigaspaces.jdbc.exec.join.JoinedRows;
import com.gigaspaces.jdbc.exec.join.algs.AbstractJoin;
import com.gigaspaces.jdbc.exec.join.algs.HashJoin;
import com.gigaspaces.jdbc.exec.join.algs.NestedLoopJoin;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.TaskGigaSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedJoinTask
implements DistributedTask<JoinResult, JoinResult> {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger("com.gigaspaces.jdbc");
    private static final Logger LOG_REDUCE = LoggerFactory.getLogger(DistributedJoinTask.class);
    @TaskGigaSpace
    private transient GigaSpace collocatedSpace;
    private JoinArgs joinArgs;
    private String taskId;
    private InsightEdgeDriverProps driverProps;

    public DistributedJoinTask(JoinArgs joinArgs, String taskId, InsightEdgeDriverProps driverProps) {
        this.joinArgs = joinArgs;
        this.taskId = taskId;
        this.driverProps = driverProps;
    }

    public JoinResult execute() throws Exception {
        Long time = System.currentTimeMillis();
        Set<JoinTrait> joinTraits = this.joinArgs.joinTraits();
        AbstractJoin join = joinTraits.contains((Object)JoinTrait.EQUALITY_CONJUNCTION) ? new HashJoin(this.joinArgs, this.collocatedSpace, this.taskId, this.driverProps) : new NestedLoopJoin(this.joinArgs, this.collocatedSpace, this.taskId, this.driverProps);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.taskId + "] Executing join by algorithm: [" + join.getClass().getName() + "]; With Join Traits: " + joinTraits + "; JoinArgs: " + this.joinArgs);
        }
        JoinResult result = join.execute();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.taskId + "] Joined rows size: " + result.getJoinedRows().size() + " in " + (System.currentTimeMillis() - time) + "ms");
        }
        return result;
    }

    public JoinResult reduce(List<AsyncResult<JoinResult>> asyncResults) throws Exception {
        long time = System.currentTimeMillis();
        ArrayList<List<JoinedRows>> mapLists = new ArrayList<List<JoinedRows>>();
        for (AsyncResult<JoinResult> asyncResult : asyncResults) {
            if (asyncResult.getException() == null) {
                List<JoinedRows> list = ((JoinResult)asyncResult.getResult()).getJoinedRows();
                mapLists.add(list);
                continue;
            }
            throw asyncResult.getException();
        }
        int size = 0;
        for (List list : mapLists) {
            size += list.size();
        }
        ArrayList<JoinedRows> arrayList = new ArrayList<JoinedRows>(size);
        for (List list : mapLists) {
            arrayList.addAll(list);
        }
        LOG_REDUCE.debug("[{}] Reduce result size: {} in {}ms", new Object[]{this.taskId, arrayList.size(), System.currentTimeMillis() - time});
        return new JoinResult(arrayList);
    }
}

