/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.algs;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.InsightEdgeQueryBuilder;
import com.gigaspaces.jdbc.exec.join.JoinArgs;
import com.gigaspaces.jdbc.exec.join.JoinTrait;
import com.gigaspaces.jdbc.exec.join.algs.Join;
import com.j_spaces.core.client.SQLQuery;
import org.apache.calcite.sql.JoinType;
import org.openspaces.core.GigaSpace;

abstract class AbstractJoin
implements Join {
    private GigaSpace clusteredSpace;
    JoinArgs joinArgs;
    GigaSpace collocatedSpace;
    protected String taskId;
    protected InsightEdgeDriverProps driverProps;

    AbstractJoin(JoinArgs joinArgs, GigaSpace collocatedSpace, String taskId, InsightEdgeDriverProps driverProps) {
        this.joinArgs = joinArgs;
        this.collocatedSpace = collocatedSpace;
        this.taskId = taskId;
        this.driverProps = driverProps;
    }

    GigaSpace inferSpaceForSecondSet() {
        if (this.joinArgs.joinTraits().contains((Object)JoinTrait.COLLOCATED_JOIN)) {
            return this.collocatedSpace;
        }
        return this.getOrCreateClusteredSpace();
    }

    boolean isFlipTables() {
        return this.joinArgs.joinType() == JoinType.RIGHT || this.joinArgs.joinType() == JoinType.INNER && this.joinArgs.left().rowCountNullable() < this.joinArgs.right().rowCountNullable();
    }

    SQLQuery<SpaceDocument> buildQuery(JoinArgs.Relation firstRel) {
        return new InsightEdgeQueryBuilder(firstRel.typeName()).withWhereClause(firstRel.whereClause(), null).withBindParameters(firstRel.getDynamicParams()).withProjection(firstRel.projectionFields()).build();
    }

    private GigaSpace getOrCreateClusteredSpace() {
        if (this.clusteredSpace == null) {
            this.clusteredSpace = this.collocatedSpace.getClustered();
        }
        return this.clusteredSpace;
    }
}

