/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.algs;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.Utils;
import com.gigaspaces.jdbc.exec.join.JoinArgs;
import com.gigaspaces.jdbc.exec.join.JoinResult;
import com.gigaspaces.jdbc.exec.join.JoinedRows;
import com.gigaspaces.jdbc.exec.join.algs.AbstractJoin;
import com.gigaspaces.jdbc.exec.join.algs.AggregatorUtils;
import com.gigaspaces.jdbc.exec.join.condition.JoinConditionFieldsCollector;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.calcite.sql.JoinType;
import org.openspaces.core.GigaSpace;

public class HashJoin
extends AbstractJoin {
    private static final Logger LOG = Logger.getLogger("com.gigaspaces.jdbc");

    public HashJoin(JoinArgs joinArgs, GigaSpace collocatedSpace, String taskId, InsightEdgeDriverProps driverProps) {
        super(joinArgs, collocatedSpace, taskId, driverProps);
    }

    @Override
    public JoinResult execute() {
        List<String> buildJoinFields;
        List<String> probeJoinFields;
        JoinArgs.Relation buildRel;
        JoinArgs.Relation probeRel;
        if (this.isFlipTables()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.taskId + "] Flipping tables...");
            }
            probeRel = this.joinArgs.right();
            buildRel = this.joinArgs.left();
            probeJoinFields = JoinConditionFieldsCollector.collectFields(this.joinArgs.joinCondition(), false);
            buildJoinFields = JoinConditionFieldsCollector.collectFields(this.joinArgs.joinCondition(), true);
        } else {
            probeRel = this.joinArgs.left();
            buildRel = this.joinArgs.right();
            probeJoinFields = JoinConditionFieldsCollector.collectFields(this.joinArgs.joinCondition(), true);
            buildJoinFields = JoinConditionFieldsCollector.collectFields(this.joinArgs.joinCondition(), false);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.taskId + "] Executing Hash Join with: probe table [" + probeRel.typeName() + "], probe join fields " + probeJoinFields + ", build table [" + buildRel.typeName() + "], build join fields " + buildJoinFields);
        }
        SQLQuery<SpaceDocument> probeQuery = this.buildQuery(probeRel);
        SQLQuery<SpaceDocument> buildQuery = this.buildQuery(buildRel);
        ListMultimap<List<Object>, SpaceDocument> buildMap = this.buildMap(buildJoinFields, buildQuery);
        ProbeScanner probeScanner = new ProbeScanner(probeRel.fields(), buildRel.fields(), probeJoinFields, buildMap);
        AggregationResult aggregateRes = this.collocatedSpace.aggregate(probeQuery, new AggregationSet().add((SpaceEntriesAggregator)probeScanner));
        JoinResult joinResult = (JoinResult)aggregateRes.get(0);
        return joinResult;
    }

    private ListMultimap<List<Object>, SpaceDocument> buildMap(List<String> buildJoinFields, SQLQuery<SpaceDocument> buildQuery) {
        long time = System.currentTimeMillis();
        SpaceDocument[] buildSet = (SpaceDocument[])this.inferSpaceForSecondSet().readMultiple(buildQuery);
        ArrayListMultimap hashMap = ArrayListMultimap.create();
        for (SpaceDocument row : buildSet) {
            List<Object> key = Utils.getDocumentFields(row, buildJoinFields);
            hashMap.put(key, (Object)row);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.taskId + "] Build map size: " + hashMap.size() + " in " + (System.currentTimeMillis() - time) + "ms");
        }
        return hashMap;
    }

    class ProbeScanner
    extends SpaceEntriesAggregator<JoinResult> {
        JoinResult joinResult = new JoinResult(new ArrayList<JoinedRows>());
        List<String> probeFields;
        List<String> buildFields;
        List<String> probeJoinFields;
        ListMultimap<List<Object>, SpaceDocument> buildMap;

        ProbeScanner(List<String> probeFields, List<String> buildFields, List<String> probeJoinFields, ListMultimap<List<Object>, SpaceDocument> buildMap) {
            this.probeFields = probeFields;
            this.buildFields = buildFields;
            this.probeJoinFields = probeJoinFields;
            this.buildMap = buildMap;
        }

        public void aggregate(SpaceEntriesAggregatorContext context) {
            List<Object> key = AggregatorUtils.getFieldsAsList(context, this.probeJoinFields);
            List matchedRows = this.buildMap.get(key);
            if (HashJoin.this.joinArgs.joinType() != JoinType.INNER || matchedRows.size() != 0) {
                Object[] outerRowValues = AggregatorUtils.getFieldsAsArray(context, this.probeFields, HashJoin.this.driverProps.getConnectionCalendar());
                List<Object[]> innerRowValues = Utils.convertSpaceDocsToArray(matchedRows, this.buildFields, HashJoin.this.driverProps.getConnectionCalendar());
                this.joinResult.getJoinedRows().add(new JoinedRows(outerRowValues, innerRowValues));
            }
        }

        public JoinResult getIntermediateResult() {
            return this.joinResult;
        }

        public void aggregateIntermediateResult(JoinResult partitionResult) {
        }

        public String getDefaultAlias() {
            return "result";
        }
    }
}

