/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.algs;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.InsightEdgeDriverProps;
import com.gigaspaces.jdbc.Utils;
import com.gigaspaces.jdbc.exec.join.JoinArgs;
import com.gigaspaces.jdbc.exec.join.JoinResult;
import com.gigaspaces.jdbc.exec.join.JoinedRows;
import com.gigaspaces.jdbc.exec.join.algs.AbstractJoin;
import com.gigaspaces.jdbc.exec.join.condition.JoinConditionMatcher;
import com.gigaspaces.jdbc.exec.join.condition.JoinConditionSidesFlipper;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.calcite.sql.JoinType;
import org.openspaces.core.GigaSpace;

public class NestedLoopJoin
extends AbstractJoin {
    private static final Logger LOG = Logger.getLogger("com.gigaspaces.jdbc");

    public NestedLoopJoin(JoinArgs joinArgs, GigaSpace collocatedSpace, String taskId, InsightEdgeDriverProps driverProps) {
        super(joinArgs, collocatedSpace, taskId, driverProps);
    }

    @Override
    public JoinResult execute() {
        JoinNode joinCondition;
        JoinArgs.Relation secondRel;
        JoinArgs.Relation firstRel;
        if (this.isFlipTables()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.taskId + "] Flipping tables...");
            }
            firstRel = this.joinArgs.right();
            secondRel = this.joinArgs.left();
            joinCondition = JoinConditionSidesFlipper.flip(this.joinArgs.joinCondition());
        } else {
            firstRel = this.joinArgs.left();
            secondRel = this.joinArgs.right();
            joinCondition = this.joinArgs.joinCondition();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.taskId + "] Executing Nested Loop with: First relation table [" + firstRel.typeName() + "], Second relation table [" + secondRel.typeName() + "], Join condition [" + joinCondition + "]");
        }
        SQLQuery<SpaceDocument> firstQuery = this.buildQuery(firstRel);
        SQLQuery<SpaceDocument> secondQuery = this.buildQuery(secondRel);
        SpaceDocument[] secondSet = (SpaceDocument[])this.inferSpaceForSecondSet().readMultiple(secondQuery);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.taskId + "] Second set size: " + secondSet.length);
        }
        Scanner scanner = new Scanner(firstRel.fields(), secondRel.fields(), secondSet, joinCondition);
        AggregationResult aggregateRes = this.collocatedSpace.aggregate(firstQuery, new AggregationSet().add((SpaceEntriesAggregator)scanner));
        JoinResult joinResult = (JoinResult)aggregateRes.get(0);
        return joinResult;
    }

    class Scanner
    extends SpaceEntriesAggregator<JoinResult> {
        JoinResult joinResult = new JoinResult(new ArrayList<JoinedRows>());
        List<String> firstRelFields;
        List<String> secondRelFields;
        SpaceDocument[] secondSet;
        JoinNode joinCondition;

        public Scanner(List<String> firstRelFields, List<String> secondRelFields, SpaceDocument[] secondSet, JoinNode joinCondition) {
            this.firstRelFields = firstRelFields;
            this.secondRelFields = secondRelFields;
            this.secondSet = secondSet;
            this.joinCondition = joinCondition;
        }

        public void aggregate(SpaceEntriesAggregatorContext context) {
            ArrayList<SpaceDocument> matchedRows = new ArrayList<SpaceDocument>();
            for (SpaceDocument innerRow : this.secondSet) {
                boolean matched = JoinConditionMatcher.eval(context, innerRow, this.joinCondition);
                if (!matched) continue;
                matchedRows.add(innerRow);
            }
            if (NestedLoopJoin.this.joinArgs.joinType() != JoinType.INNER || matchedRows.size() != 0) {
                Object[] outerRowValues = Utils.convertEntryToArray(context, this.firstRelFields, NestedLoopJoin.this.driverProps.getConnectionCalendar());
                List<Object[]> innerRowValues = Utils.convertSpaceDocsToArray(matchedRows, this.secondRelFields, NestedLoopJoin.this.driverProps.getConnectionCalendar());
                this.joinResult.getJoinedRows().add(new JoinedRows(outerRowValues, innerRowValues));
            }
        }

        public JoinResult getIntermediateResult() {
            return this.joinResult;
        }

        public void aggregateIntermediateResult(JoinResult partitionResult) {
        }

        public String getDefaultAlias() {
            return "result";
        }
    }
}

