/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.condition;

import com.gigaspaces.jdbc.exec.join.condition.JoinAndNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinBinaryNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqualityConjunctionChecker;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNodeVisitor;
import com.gigaspaces.jdbc.exec.join.condition.JoinOrNode;

public class JoinCollocationChecker {
    public static boolean isCollocatedJoin(JoinNode joinCondition, String leftRoutingField, String rightRoutingField) {
        if (!JoinEqualityConjunctionChecker.isEqualityConjunction(joinCondition)) {
            return false;
        }
        FieldFinder routingFinder = new FieldFinder(leftRoutingField, rightRoutingField);
        joinCondition.accept(routingFinder);
        return routingFinder.found;
    }

    public static class FieldFinder
    implements JoinNodeVisitor {
        private String leftField;
        private String rightField;
        private boolean found = false;

        public FieldFinder(String leftField, String rightField) {
            this.leftField = leftField;
            this.rightField = rightField;
        }

        @Override
        public void visit(JoinEqNode eq) {
            this.searchBinaryFields(eq);
        }

        @Override
        public void visit(JoinGtNode gt) {
            this.searchBinaryFields(gt);
        }

        @Override
        public void visit(JoinGtEqNode gtEq) {
            this.searchBinaryFields(gtEq);
        }

        @Override
        public void visit(JoinLessNode less) {
            this.searchBinaryFields(less);
        }

        @Override
        public void visit(JoinLessEqNode lessEq) {
            this.searchBinaryFields(lessEq);
        }

        private void searchBinaryFields(JoinBinaryNode eq) {
            if (eq.leftField().equalsIgnoreCase(this.leftField) && eq.rightField().equalsIgnoreCase(this.rightField)) {
                this.found = true;
            }
        }

        @Override
        public void visit(JoinOrNode or) {
            throw new IllegalStateException("OR node is not expected");
        }

        @Override
        public void visit(JoinAndNode and) {
            and.left().accept(this);
            if (!this.found) {
                and.right().accept(this);
            }
        }
    }
}

