/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.condition;

import com.gigaspaces.jdbc.exec.join.condition.JoinAndNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinBinaryNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNodeVisitor;
import com.gigaspaces.jdbc.exec.join.condition.JoinOrNode;
import java.util.ArrayList;
import java.util.List;

public class JoinConditionFieldsCollector {
    public static List<String> collectFields(JoinNode joinCondition, boolean collectLeft) {
        Visitor visitor = new Visitor(collectLeft);
        joinCondition.accept(visitor);
        return visitor.fields;
    }

    public static class Visitor
    implements JoinNodeVisitor {
        private List<String> fields = new ArrayList<String>();
        private boolean collectLeft;

        public Visitor(boolean collectLeft) {
            this.collectLeft = collectLeft;
        }

        @Override
        public void visit(JoinEqNode eq) {
            this.collectBinaryOperationFields(eq);
        }

        @Override
        public void visit(JoinGtNode gt) {
            this.collectBinaryOperationFields(gt);
        }

        @Override
        public void visit(JoinGtEqNode gtEq) {
            this.collectBinaryOperationFields(gtEq);
        }

        @Override
        public void visit(JoinLessNode less) {
            this.collectBinaryOperationFields(less);
        }

        @Override
        public void visit(JoinLessEqNode lessEq) {
            this.collectBinaryOperationFields(lessEq);
        }

        private void collectBinaryOperationFields(JoinBinaryNode eq) {
            if (this.collectLeft) {
                this.fields.add(eq.leftField());
            } else {
                this.fields.add(eq.rightField());
            }
        }

        @Override
        public void visit(JoinOrNode or) {
            or.left().accept(this);
            or.right().accept(this);
        }

        @Override
        public void visit(JoinAndNode and) {
            and.left().accept(this);
            and.right().accept(this);
        }
    }
}

