/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.condition;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.jdbc.exec.join.condition.JoinAndNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinBinaryNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNodeVisitor;
import com.gigaspaces.jdbc.exec.join.condition.JoinOrNode;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.util.Objects;

public class JoinConditionMatcher {
    public static boolean eval(SpaceEntriesAggregatorContext left, SpaceDocument right, JoinNode condition) {
        Matcher matcher = new Matcher(left, right);
        condition.accept(matcher);
        return matcher.matches;
    }

    private static class Matcher
    implements JoinNodeVisitor {
        SpaceEntriesAggregatorContext left;
        SpaceDocument right;
        boolean matches;

        Matcher(SpaceEntriesAggregatorContext left, SpaceDocument right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void visit(JoinEqNode eq) {
            this.matches = Objects.equals(this.getLeftVal(eq), this.getRightVal(eq));
        }

        @Override
        public void visit(JoinGtNode gt) {
            this.matches = this.getRightVal(gt).compareTo(this.getLeftVal(gt)) < 0;
        }

        @Override
        public void visit(JoinGtEqNode gtEq) {
            this.matches = this.getRightVal(gtEq).compareTo(this.getLeftVal(gtEq)) <= 0;
        }

        @Override
        public void visit(JoinLessNode less) {
            this.matches = this.getRightVal(less).compareTo(this.getLeftVal(less)) > 0;
        }

        @Override
        public void visit(JoinLessEqNode lessEq) {
            this.matches = this.getRightVal(lessEq).compareTo(this.getLeftVal(lessEq)) >= 0;
        }

        private Comparable getRightVal(JoinBinaryNode node) {
            return (Comparable)this.right.getProperty(node.rightField());
        }

        private Object getLeftVal(JoinBinaryNode node) {
            return this.left.getPathValue(node.leftField());
        }

        @Override
        public void visit(JoinOrNode or) {
            Matcher leftMatcher = new Matcher(this.left, this.right);
            or.left().accept(leftMatcher);
            if (leftMatcher.matches) {
                this.matches = true;
            } else {
                Matcher rightMatcher = new Matcher(this.left, this.right);
                or.right().accept(rightMatcher);
                this.matches = rightMatcher.matches;
            }
        }

        @Override
        public void visit(JoinAndNode and) {
            Matcher leftMatcher = new Matcher(this.left, this.right);
            and.left().accept(leftMatcher);
            if (leftMatcher.matches) {
                Matcher rightMatcher = new Matcher(this.left, this.right);
                and.right().accept(rightMatcher);
                this.matches = rightMatcher.matches;
            } else {
                this.matches = false;
            }
        }
    }
}

