/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.exec.join.condition;

import com.gigaspaces.jdbc.exec.join.condition.JoinAndNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinBinaryNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNodeVisitor;
import com.gigaspaces.jdbc.exec.join.condition.JoinOrNode;

public class JoinConditionSidesFlipper {
    public static JoinNode flip(JoinNode joinNode) {
        Flipper flipper = new Flipper();
        joinNode.accept(flipper);
        return flipper.flippedNode;
    }

    private static class Flipper
    implements JoinNodeVisitor {
        JoinNode flippedNode;

        private Flipper() {
        }

        @Override
        public void visit(JoinEqNode eq) {
            this.flipBinaryFields(eq);
        }

        @Override
        public void visit(JoinGtNode gt) {
            this.flipBinaryFields(gt);
        }

        @Override
        public void visit(JoinGtEqNode gtEq) {
            this.flipBinaryFields(gtEq);
        }

        @Override
        public void visit(JoinLessNode less) {
            this.flipBinaryFields(less);
        }

        @Override
        public void visit(JoinLessEqNode lessEq) {
            this.flipBinaryFields(lessEq);
        }

        private void flipBinaryFields(JoinBinaryNode eq) {
            this.flippedNode = new JoinEqNode(eq.rightField(), eq.leftField());
        }

        @Override
        public void visit(JoinOrNode or) {
            Flipper leftFlipper = new Flipper();
            Flipper rightFlipper = new Flipper();
            or.left().accept(leftFlipper);
            or.right().accept(rightFlipper);
            this.flippedNode = new JoinOrNode(leftFlipper.flippedNode, rightFlipper.flippedNode);
        }

        @Override
        public void visit(JoinAndNode and) {
            Flipper leftFlipper = new Flipper();
            Flipper rightFlipper = new Flipper();
            and.left().accept(leftFlipper);
            and.right().accept(rightFlipper);
            this.flippedNode = new JoinAndNode(leftFlipper.flippedNode, rightFlipper.flippedNode);
        }
    }
}

