/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rel;

import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.gigaspaces.jdbc.rules.InsightEdgeRules;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class InsightEdgeAggregate
extends Aggregate
implements InsightEdgeRel {
    public InsightEdgeAggregate(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traits, child, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public void implement(InsightEdgeRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List<String> fieldNames = InsightEdgeRules.insightEdgeFieldNames(this.getInput().getRowType());
        for (Pair namedAggCall : this.getNamedAggCalls()) {
            String name = (String)namedAggCall.getValue();
            AggregateCall aggCall = (AggregateCall)namedAggCall.getKey();
            SqlAggFunction aggregation = aggCall.getAggregation();
            List argIds = aggCall.getArgList();
            List<String> argFieldNames = this.convertArgIdsToFieldNames(argIds, fieldNames);
            String aggTypeName = aggregation.getName();
            if (aggTypeName.contains("$")) {
                aggTypeName = aggTypeName.replace("$", "");
                aggTypeName = aggTypeName.substring(0, aggTypeName.length() - 1);
            }
            implementor.addAggregation(name, aggTypeName, argFieldNames);
        }
        Iterator iterator = this.groupSet.iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            String fieldName = fieldNames.get(group);
            implementor.addGroup(fieldName);
        }
    }

    private List<String> convertArgIdsToFieldNames(List<Integer> argIds, List<String> fieldNames) {
        ArrayList<String> argNames = new ArrayList<String>();
        for (Integer argId : argIds) {
            argNames.add(fieldNames.get(argId));
        }
        return argNames;
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new InsightEdgeAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
    }
}

