/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rel;

import com.gigaspaces.jdbc.rel.DynamicParam;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.gigaspaces.jdbc.rel.SimpleRexNode;
import com.gigaspaces.jdbc.rules.InsightEdgeRules;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class InsightEdgeFilter
extends Filter
implements InsightEdgeRel {
    private static final String INSIGHTEDGE_DYNAMIC_PARAM_VALUE = " ? ";

    public InsightEdgeFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
        super(cluster, traitSet, child, condition);
    }

    public InsightEdgeFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new InsightEdgeFilter(this.getCluster(), traitSet, input, condition);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(InsightEdgeRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        Translator translator = new Translator(InsightEdgeRules.insightEdgeFieldNames(this.getRowType()));
        String whereClause = translator.translate(this.condition, false);
        implementor.addWhereItems(translator.translateRexNodeToSimple(this.condition));
        implementor.addWhereClause(whereClause);
        implementor.setDynamicParams(translator.dynamicParams);
    }

    static class Translator {
        private JavaTypeFactory javaTypeFactory = new JavaTypeFactoryImpl();
        private List<String> fieldNames;
        private List<DynamicParam> dynamicParams = new ArrayList<DynamicParam>();

        Translator(List<String> fieldNames) {
            this.fieldNames = fieldNames;
        }

        private String translate(RexNode node, boolean isNested) {
            switch (node.getKind()) {
                case AND: {
                    return this.translateAndOr(node, SqlKind.AND, isNested);
                }
                case OR: {
                    return this.translateAndOr(node, SqlKind.OR, isNested);
                }
                case NOT: {
                    return this.translateNot(node);
                }
                case EQUALS: {
                    return this.translateBinary("=", "=", (RexCall)node);
                }
                case NOT_EQUALS: {
                    return this.translateBinary("<>", "<>", (RexCall)node);
                }
                case LESS_THAN: {
                    return this.translateBinary("<", ">", (RexCall)node);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("<=", ">=", (RexCall)node);
                }
                case GREATER_THAN: {
                    return this.translateBinary(">", "<", (RexCall)node);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary(">=", "<=", (RexCall)node);
                }
                case LIKE: {
                    return this.translateBinary("like", null, (RexCall)node);
                }
                case IS_NULL: {
                    return this.translateUnary("IS NULL", (RexCall)node);
                }
                case IS_NOT_NULL: {
                    return this.translateUnary("IS NOT NULL", (RexCall)node);
                }
            }
            throw new AssertionError((Object)("cannot translate " + node));
        }

        private String translateAndOr(RexNode node, SqlKind kind, boolean isNested) {
            RexCall rexCall = (RexCall)node;
            ArrayList<String> stringPredicates = new ArrayList<String>();
            for (RexNode operand : rexCall.getOperands()) {
                String stringPredicate = this.translate(operand, true);
                stringPredicates.add(stringPredicate);
            }
            String start = isNested ? "(" : "";
            String end = isNested ? ")" : "";
            switch (kind) {
                case AND: {
                    return Util.toString(stringPredicates, (String)start, (String)" AND ", (String)end);
                }
                case OR: {
                    return Util.toString(stringPredicates, (String)start, (String)" OR ", (String)end);
                }
            }
            throw new RuntimeException("Unexpected kind " + kind);
        }

        private String translateNot(RexNode node) {
            RexNode operand = (RexNode)((RexCall)node).getOperands().get(0);
            switch (operand.getKind()) {
                case LIKE: {
                    return this.translateBinary("NOT LIKE", null, (RexCall)operand);
                }
            }
            return " NOT " + this.translate(operand, true);
        }

        private String translateUnary(String op, RexCall call) {
            RexNode operand = (RexNode)call.operands.get(0);
            switch (operand.getKind()) {
                case INPUT_REF: {
                    RexInputRef node1 = (RexInputRef)operand;
                    String name = this.fieldNames.get(node1.getIndex());
                    return name + " " + op;
                }
            }
            throw new RuntimeException("cannot translate " + operand);
        }

        private String translateBinary(String op, String rop, RexCall call) {
            RexNode right;
            RexNode left = (RexNode)call.operands.get(0);
            String expression = this.translateBinary2(op, left, right = (RexNode)call.operands.get(1));
            if (expression != null) {
                return expression;
            }
            expression = this.translateBinary2(rop, right, left);
            if (expression != null) {
                return expression;
            }
            throw new AssertionError((Object)("cannot translate op " + op + " call " + call));
        }

        private String translateBinary2(String op, RexNode left, RexNode right) {
            String value;
            switch (right.getKind()) {
                case LITERAL: {
                    RexLiteral literal = (RexLiteral)right;
                    value = Translator.literalValue(literal);
                    break;
                }
                case DYNAMIC_PARAM: {
                    value = InsightEdgeFilter.INSIGHTEDGE_DYNAMIC_PARAM_VALUE;
                    break;
                }
                case CAST: {
                    return this.translateBinary2(op, left, (RexNode)((RexCall)right).operands.get(0));
                }
                default: {
                    return null;
                }
            }
            switch (left.getKind()) {
                case LITERAL: {
                    if (right.getKind() == SqlKind.LITERAL) {
                        return this.translateOp2(op, Translator.literalValue((RexLiteral)left), value);
                    }
                    return null;
                }
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String fieldName = this.fieldNames.get(left1.getIndex());
                    if (right.getKind() == SqlKind.DYNAMIC_PARAM) {
                        String dynamicParamName = ((RexDynamicParam)right).getName();
                        Class type = (Class)this.javaTypeFactory.getJavaClass(right.getType());
                        this.dynamicParams.add(new DynamicParam(dynamicParamName, fieldName, type));
                    }
                    return this.translateOp2(op, fieldName, value);
                }
                case CAST: {
                    return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right);
                }
            }
            return null;
        }

        private String translateOp2(String op, String name, String value) {
            return name + " " + op + " " + value;
        }

        private static String literalValue(RexLiteral literal) {
            Comparable value = literal.getValue();
            Object value2 = literal.getValue2();
            if (literal.getTypeName() == SqlTypeName.CHAR) {
                return "'" + String.valueOf(value2) + "'";
            }
            if (literal.getTypeName() == SqlTypeName.TIMESTAMP) {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)value;
                ZonedDateTime zonedDateTime = gregorianCalendar.toZonedDateTime();
                String formattedDate = zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                return "'" + formattedDate + "'";
            }
            if (literal.getTypeName() == SqlTypeName.DATE) {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)value;
                ZonedDateTime zonedDateTime = gregorianCalendar.toZonedDateTime();
                String formattedDate = zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                return "'" + formattedDate + "'";
            }
            if (literal.getTypeName() == SqlTypeName.TIME) {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)value;
                ZonedDateTime zonedDateTime = gregorianCalendar.toZonedDateTime();
                String formattedDate = zonedDateTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                return "'" + formattedDate + "'";
            }
            return String.valueOf(value);
        }

        private SimpleRexNode translateRexNodeToSimple(RexNode rexNode) {
            SimpleRexNode simpleRexNode = new SimpleRexNode();
            simpleRexNode.setSqlKind(rexNode.getKind());
            switch (rexNode.getKind()) {
                case AND: {
                    simpleRexNode.setValue("AND");
                    return this.translateAndOrRexNodeToSimple(rexNode, simpleRexNode);
                }
                case OR: {
                    simpleRexNode.setValue("OR");
                    return this.translateAndOrRexNodeToSimple(rexNode, simpleRexNode);
                }
                case NOT: {
                    simpleRexNode.setValue("NOT");
                    simpleRexNode.operands.add(this.translateNotToSimple(rexNode));
                    return simpleRexNode;
                }
                case EQUALS: {
                    simpleRexNode.setValue("EQUALS");
                    break;
                }
                case NOT_EQUALS: {
                    simpleRexNode.setValue("NOT_EQUALS");
                    break;
                }
                case LESS_THAN: {
                    simpleRexNode.setValue("LESS_THAN");
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    simpleRexNode.setValue("LESS_THAN_OR_EQUAL");
                    break;
                }
                case GREATER_THAN: {
                    simpleRexNode.setValue("GREATER_THAN");
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    simpleRexNode.setValue("GREATER_THAN_OR_EQUAL");
                    break;
                }
                case LIKE: {
                    simpleRexNode.setValue("LIKE");
                    break;
                }
                case IS_NULL: {
                    simpleRexNode.setValue("IS_NULL");
                    simpleRexNode.operands.add(this.translateSingleRexNodeValue((RexNode)((RexCall)rexNode).operands.get(0)));
                    return simpleRexNode;
                }
                case IS_NOT_NULL: {
                    simpleRexNode.setValue("IS_NOT_NULL");
                    simpleRexNode.operands.add(this.translateSingleRexNodeValue((RexNode)((RexCall)rexNode).operands.get(0)));
                    return simpleRexNode;
                }
                default: {
                    throw new AssertionError((Object)("cannot translate " + rexNode));
                }
            }
            return this.translateBinaryRexNodeToSimple(rexNode, simpleRexNode);
        }

        private SimpleRexNode translateBinaryRexNodeToSimple(RexNode rexNode, SimpleRexNode simpleRexNode) {
            RexCall rexCall = (RexCall)rexNode;
            SimpleRexNode left = this.translateSingleRexNodeValue((RexNode)rexCall.operands.get(0));
            SimpleRexNode right = this.translateSingleRexNodeValue((RexNode)rexCall.operands.get(1));
            if (((RexNode)rexCall.operands.get(0)).isA(SqlKind.INPUT_REF)) {
                simpleRexNode.getOperands().add(left);
                simpleRexNode.getOperands().add(right);
            } else {
                simpleRexNode.getOperands().add(right);
                simpleRexNode.getOperands().add(left);
                simpleRexNode.setSqlKind(Translator.reverseOp(simpleRexNode.getSqlKind()));
                simpleRexNode.setValue(simpleRexNode.getSqlKind().toString());
            }
            return simpleRexNode;
        }

        private static SqlKind reverseOp(SqlKind op) {
            switch (op) {
                case EQUALS: {
                    return SqlKind.EQUALS;
                }
                case NOT_EQUALS: {
                    return SqlKind.NOT_EQUALS;
                }
                case LESS_THAN: {
                    return SqlKind.GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return SqlKind.GREATER_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return SqlKind.LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return SqlKind.LESS_THAN_OR_EQUAL;
                }
                case LIKE: {
                    return SqlKind.LIKE;
                }
            }
            throw new AssertionError((Object)("cannot reverse " + op));
        }

        private SimpleRexNode translateAndOrRexNodeToSimple(RexNode rexNode, SimpleRexNode simpleRexNode) {
            RexCall rexCall = (RexCall)rexNode;
            for (RexNode operand : rexCall.operands) {
                simpleRexNode.getOperands().add(this.translateRexNodeToSimple(operand));
            }
            return simpleRexNode;
        }

        private SimpleRexNode translateNotToSimple(RexNode node) {
            RexNode operand = (RexNode)((RexCall)node).getOperands().get(0);
            SimpleRexNode simpleNotRexNode = new SimpleRexNode();
            simpleNotRexNode.setSqlKind(operand.getKind());
            switch (operand.getKind()) {
                case LIKE: {
                    simpleNotRexNode.setValue("LIKE");
                    return this.translateBinaryRexNodeToSimple(operand, simpleNotRexNode);
                }
            }
            return this.translateRexNodeToSimple(operand);
        }

        private SimpleRexNode translateSingleRexNodeValue(RexNode rexNode) {
            SimpleRexNode simpleSingleRexNode = new SimpleRexNode();
            simpleSingleRexNode.setSqlKind(rexNode.getKind());
            switch (rexNode.getKind()) {
                case LITERAL: {
                    RexLiteral literal = (RexLiteral)rexNode;
                    simpleSingleRexNode.setValue(Translator.literalValue(literal));
                    break;
                }
                case DYNAMIC_PARAM: {
                    simpleSingleRexNode.setValue(InsightEdgeFilter.INSIGHTEDGE_DYNAMIC_PARAM_VALUE);
                    break;
                }
                case INPUT_REF: {
                    RexInputRef rexInputRef = (RexInputRef)rexNode;
                    String fieldName = this.fieldNames.get(rexInputRef.getIndex());
                    simpleSingleRexNode.setValue(fieldName);
                    break;
                }
                case CAST: {
                    simpleSingleRexNode.setValue(rexNode.toString());
                }
                default: {
                    return null;
                }
            }
            return simpleSingleRexNode;
        }
    }
}

