/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rel;

import com.gigaspaces.jdbc.exec.join.condition.JoinAndNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinOrNode;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.gigaspaces.jdbc.rules.InsightEdgeRules;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;

public class InsightEdgeJoin
extends Join
implements InsightEdgeRel {
    public InsightEdgeJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    @Override
    public void implement(InsightEdgeRel.Implementor implementor) {
        implementor.visitLeftJoin(this.left);
        implementor.visitRightJoin(this.right);
        String joinType = this.getJoinType().name();
        implementor.setJoinType(joinType);
        RelDataType joinedRowType = this.getCluster().getTypeFactory().builder().addAll((Iterable)this.getSystemFieldList()).addAll((Iterable)this.getLeft().getRowType().getFieldList()).addAll((Iterable)this.getRight().getRowType().getFieldList()).build();
        List<String> fieldNames = InsightEdgeRules.insightEdgeFieldNames(joinedRowType);
        InsightEdgeRules.RexToInsightEdgeTranslator translator = new InsightEdgeRules.RexToInsightEdgeTranslator(fieldNames);
        JoinNode joinCondition = this.traverseCondition(this.condition, translator);
        implementor.setJoinCondition(joinCondition);
        implementor.setJoinLeftFields(InsightEdgeRules.insightEdgeFieldNames(this.getLeft().getRowType()));
        implementor.setJoinRightFields(InsightEdgeRules.insightEdgeFieldNames(this.getRight().getRowType()));
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new InsightEdgeJoin(this.getCluster(), traitSet, left, right, conditionExpr, this.getVariablesSet(), joinType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    private JoinNode traverseCondition(RexNode rexNode, InsightEdgeRules.RexToInsightEdgeTranslator translator) {
        RexCall rexCall = (RexCall)rexNode;
        List operands = rexCall.getOperands();
        RexNode op1 = (RexNode)operands.get(0);
        RexNode op2 = (RexNode)operands.get(1);
        String operator = rexCall.getOperator().getName();
        if ("=".equals(operator)) {
            JoinFields joinFields = this.getJoinFields(op1, op2, translator);
            return new JoinEqNode(joinFields.getLeft(), joinFields.getRight());
        }
        if (">".equals(operator)) {
            JoinFields joinFields = this.getJoinFields(op1, op2, translator);
            return new JoinGtNode(joinFields.getLeft(), joinFields.getRight());
        }
        if (">=".equals(operator)) {
            JoinFields joinFields = this.getJoinFields(op1, op2, translator);
            return new JoinGtEqNode(joinFields.getLeft(), joinFields.getRight());
        }
        if ("<".equals(operator)) {
            JoinFields joinFields = this.getJoinFields(op1, op2, translator);
            return new JoinLessNode(joinFields.getLeft(), joinFields.getRight());
        }
        if ("<=".equals(operator)) {
            JoinFields joinFields = this.getJoinFields(op1, op2, translator);
            return new JoinLessEqNode(joinFields.getLeft(), joinFields.getRight());
        }
        if ("AND".equalsIgnoreCase(operator)) {
            JoinNode left = this.traverseCondition(op1, translator);
            JoinNode right = this.traverseCondition(op2, translator);
            return new JoinAndNode(left, right);
        }
        if ("OR".equalsIgnoreCase(operator)) {
            JoinNode left = this.traverseCondition(op1, translator);
            JoinNode right = this.traverseCondition(op2, translator);
            return new JoinOrNode(left, right);
        }
        throw new RuntimeException("Unexpected operator " + operator);
    }

    private boolean isLeftConditionField(RexInputRef ref) {
        return ref.getIndex() < this.getLeft().getRowType().getFieldCount();
    }

    private JoinFields getJoinFields(RexNode op1, RexNode op2, InsightEdgeRules.RexToInsightEdgeTranslator translator) {
        String right;
        String left;
        String field1 = (String)op1.accept((RexVisitor)translator);
        String field2 = (String)op2.accept((RexVisitor)translator);
        if (this.isLeftConditionField((RexInputRef)op1)) {
            left = field1;
            right = field2;
        } else {
            left = field2;
            right = field1;
        }
        return new JoinFields(left, right);
    }

    private static class JoinFields {
        private String left;
        private String right;

        public JoinFields(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }
    }
}

