/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rel;

import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;

public class InsightEdgeSort
extends Sort
implements InsightEdgeRel {
    public InsightEdgeSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode convert, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, convert, collation, offset, fetch);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public void implement(InsightEdgeRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List sortCollations = this.collation.getFieldCollations();
        ArrayList<String> fieldOrder = new ArrayList<String>();
        if (!sortCollations.isEmpty()) {
            List fields = this.getRowType().getFieldList();
            for (RelFieldCollation fieldCollation : sortCollations) {
                String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
                String direction = "ASC";
                if (fieldCollation.getDirection().equals((Object)RelFieldCollation.Direction.DESCENDING)) {
                    direction = "DESC";
                }
                fieldOrder.add(name + " " + direction);
            }
            implementor.addFieldOrder(fieldOrder);
        }
        this.implementLimitOffset(implementor);
    }

    private void implementLimitOffset(InsightEdgeRel.Implementor implementor) {
        String limitOffsetClause = null;
        if (this.offset != null) {
            limitOffsetClause = "rownum > " + this.offset;
        }
        if (this.fetch != null) {
            int upperRownum = RexLiteral.intValue((RexNode)this.fetch) + 1;
            limitOffsetClause = "rownum < " + upperRownum;
        }
        if (limitOffsetClause != null) {
            implementor.addLimitOffsetClause(limitOffsetClause);
        }
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new InsightEdgeSort(this.getCluster(), traitSet, input, this.collation, offset, fetch);
    }
}

