/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rel;

import com.gigaspaces.jdbc.InsightEdgeMethod;
import com.gigaspaces.jdbc.InsightEdgeQueryable;
import com.gigaspaces.jdbc.exec.join.condition.JoinAndNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinBinaryNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinGtNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessEqNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinLessNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNode;
import com.gigaspaces.jdbc.exec.join.condition.JoinNodeVisitor;
import com.gigaspaces.jdbc.exec.join.condition.JoinOrNode;
import com.gigaspaces.jdbc.rel.DynamicParam;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.gigaspaces.jdbc.rel.SimpleRexNode;
import com.gigaspaces.jdbc.rules.InsightEdgeRules;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;

public class InsightEdgeToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    public InsightEdgeToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new InsightEdgeToEnumerableConverter(this.getCluster(), traitSet, (RelNode)InsightEdgeToEnumerableConverter.sole(inputs));
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        InsightEdgeRel.Implementor insightEdgeImplementor = new InsightEdgeRel.Implementor();
        insightEdgeImplementor.visitChild(0, this.getInput());
        if (insightEdgeImplementor.isJoin()) {
            return this.findJoin(implementor, pref, insightEdgeImplementor);
        }
        return this.find(implementor, pref, insightEdgeImplementor);
    }

    private EnumerableRel.Result findJoin(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref, InsightEdgeRel.Implementor insightEdgeImplementor) {
        BlockBuilder list = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression table = list.append("table", insightEdgeImplementor.getJoinLeft().getTable().getExpression(InsightEdgeQueryable.class));
        Expression joinType = list.append("joinType", (Expression)Expressions.constant((Object)insightEdgeImplementor.getJoinType()));
        Expression rightTypeName = list.append("rightTypeName", (Expression)Expressions.constant((Object)insightEdgeImplementor.getJoinRight().getInsightEdgeTable().getSpaceTypeName()));
        Expression rightRoutingField = list.append("rightRoutingField", (Expression)Expressions.constant((Object)insightEdgeImplementor.getJoinRight().getInsightEdgeTable().getRoutingFieldName()));
        Expression leftDynamicParams = list.append("leftDynamicParams", this.dynamicsParametersToExpression(insightEdgeImplementor.getJoinLeft().getDynamicParams()));
        Expression rightDynamicParams = list.append("rightDynamicParams", this.dynamicsParametersToExpression(insightEdgeImplementor.getJoinRight().getDynamicParams()));
        Expression leftWhereClause = list.append("leftWhereClause", (Expression)Expressions.constant((Object)insightEdgeImplementor.getJoinLeft().getWhereClause()));
        Expression rightWhereClause = list.append("rightWhereClause", (Expression)Expressions.constant((Object)insightEdgeImplementor.getJoinRight().getWhereClause()));
        Expression leftProjectionFields = list.append("leftProjectionFields", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getJoinLeft().getProjectionFields(), String.class));
        Expression rightProjectionFields = list.append("rightProjectionFields", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getJoinRight().getProjectionFields(), String.class));
        Expression leftFields = list.append("leftFields", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getJoinLeftFields(), String.class));
        Expression rightFields = list.append("rightFields", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getJoinRightFields(), String.class));
        Expression joinCondition = list.append("joinCondition", this.joinNodeToExpression(insightEdgeImplementor.getJoinCondition()));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)InsightEdgeMethod.INSIGHTEDGE_QUERYABLE_FIND_JOIN.method, (Expression[])new Expression[]{implementor.getRootExpression(), joinType, rightTypeName, rightRoutingField, leftWhereClause, rightWhereClause, leftDynamicParams, rightDynamicParams, leftProjectionFields, rightProjectionFields, leftFields, rightFields, joinCondition}));
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private EnumerableRel.Result find(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref, InsightEdgeRel.Implementor insightEdgeImplementor) {
        BlockBuilder list = new BlockBuilder();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(Pair.zip(InsightEdgeRules.insightEdgeFieldNames(this.rowType), (List)new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return InsightEdgeToEnumerableConverter.this.rowType.getFieldCount();
            }
        }), Pair.class));
        Expression projectionFields = list.append("projectionFields", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getProjectionFields(), String.class));
        Expression table = list.append("table", insightEdgeImplementor.getTable().getExpression(InsightEdgeQueryable.class));
        Expression whereClause = list.append("whereClause", (Expression)Expressions.constant((Object)insightEdgeImplementor.getWhereClause()));
        Expression whereItems = list.append("whereItems", this.simpleRexNodeToExpression(insightEdgeImplementor.getWhereItems()));
        Expression limitOffset = list.append("limitOffset", (Expression)Expressions.constant((Object)insightEdgeImplementor.getLimitOffsetClause()));
        Expression dynamicParams = list.append("dynamicParams", this.dynamicsParametersToExpression(insightEdgeImplementor.getDynamicParams()));
        Expression order = list.append("order", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getOrder(), String.class));
        Expression aggregationFunctions = list.append("aggregationFunctions", this.aggregationFunctionsToExpression(insightEdgeImplementor.getAggregationFunctions()));
        Expression aggregationCallNames = list.append("aggregationCallNames", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getAggregationCallNames(), String.class));
        Expression groups = list.append("groups", (Expression)InsightEdgeToEnumerableConverter.constantArrayList(insightEdgeImplementor.getGroups(), String.class));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)InsightEdgeMethod.INSIGHTEDGE_QUERYABLE_FIND.method, (Expression[])new Expression[]{implementor.getRootExpression(), fields, projectionFields, whereClause, whereItems, limitOffset, dynamicParams, order, aggregationCallNames, aggregationFunctions, groups}));
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, InsightEdgeToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Lists.transform(values, (Function)new Function<T, Expression>(){

            public Expression apply(T a0) {
                return Expressions.constant(a0);
            }
        });
    }

    private Expression dynamicsParametersToExpression(List<DynamicParam> dynamicParams) {
        Constructor dynamicParamConstructor = Types.lookupConstructor(DynamicParam.class, (Class[])new Class[]{String.class, String.class, Class.class});
        ArrayList<NewExpression> expressions = new ArrayList<NewExpression>(dynamicParams.size());
        for (DynamicParam param : dynamicParams) {
            NewExpression dynamicParamExpression = Expressions.new_((Constructor)dynamicParamConstructor, (Expression[])new Expression[]{Expressions.constant((Object)param.getName()), Expressions.constant((Object)param.getFieldName()), Expressions.constant((Object)param.getType())});
            expressions.add(dynamicParamExpression);
        }
        return InsightEdgeToEnumerableConverter.constantArrayList(expressions, DynamicParam.class);
    }

    private Expression simpleRexNodeToExpression(SimpleRexNode simpleRexNode) {
        if (simpleRexNode == null) {
            return Expressions.constant(null);
        }
        Constructor simpleRexNodeConstructor = Types.lookupConstructor(SimpleRexNode.class, (Class[])new Class[]{SqlKind.class, String.class, List.class});
        NewExpression simpleRexNodeExpression = Expressions.new_((Constructor)simpleRexNodeConstructor, (Expression[])new Expression[]{Expressions.constant((Object)simpleRexNode.getSqlKind()), Expressions.constant((Object)simpleRexNode.getValue()), this.simpleRexNodeOperandsListToExpression(simpleRexNode.getOperands())});
        return simpleRexNodeExpression;
    }

    private Expression simpleRexNodeOperandsListToExpression(List<SimpleRexNode> simpleRexNodeList) {
        if (simpleRexNodeList == null || simpleRexNodeList.isEmpty()) {
            return Expressions.constant(null);
        }
        ArrayList list = new ArrayList();
        simpleRexNodeList.forEach(node -> list.add(this.simpleRexNodeToExpression((SimpleRexNode)node)));
        return InsightEdgeToEnumerableConverter.constantArrayList(list, SimpleRexNode.class);
    }

    private Expression aggregationFunctionsToExpression(List<Pair<String, List<String>>> aggregations) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Pair<String, List<String>> entry : aggregations) {
            MethodCallExpression valueExpr = InsightEdgeToEnumerableConverter.constantArrayList((List)entry.getValue(), String.class);
            list.add(Pair.of((Object)entry.getKey(), (Object)valueExpr));
        }
        return InsightEdgeToEnumerableConverter.constantArrayList(InsightEdgeToEnumerableConverter.constantList(list), Pair.class);
    }

    private Expression joinNodeToExpression(JoinNode joinNode) {
        JoinNodeExpressionBuilder expressionBuilder = new JoinNodeExpressionBuilder();
        joinNode.accept(expressionBuilder);
        return expressionBuilder.getExpression();
    }

    private static class JoinNodeExpressionBuilder
    implements JoinNodeVisitor {
        private static final Constructor AND_CONSTRUCTOR = Types.lookupConstructor(JoinAndNode.class, (Class[])new Class[]{JoinNode.class, JoinNode.class});
        private static final Constructor OR_CONSTRUCTOR = Types.lookupConstructor(JoinOrNode.class, (Class[])new Class[]{JoinNode.class, JoinNode.class});
        private static final Constructor EQ_CONSTRUCTOR = Types.lookupConstructor(JoinEqNode.class, (Class[])new Class[]{String.class, String.class});
        private static final Constructor GT_CONSTRUCTOR = Types.lookupConstructor(JoinGtNode.class, (Class[])new Class[]{String.class, String.class});
        private static final Constructor GT_EQ_CONSTRUCTOR = Types.lookupConstructor(JoinGtEqNode.class, (Class[])new Class[]{String.class, String.class});
        private static final Constructor LESS_CONSTRUCTOR = Types.lookupConstructor(JoinLessNode.class, (Class[])new Class[]{String.class, String.class});
        private static final Constructor LESS_EQ_CONSTRUCTOR = Types.lookupConstructor(JoinLessEqNode.class, (Class[])new Class[]{String.class, String.class});
        private Expression expression;

        private JoinNodeExpressionBuilder() {
        }

        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public void visit(JoinEqNode eq) {
            this.expression = this.createBinaryExpression(eq, EQ_CONSTRUCTOR);
        }

        @Override
        public void visit(JoinOrNode or) {
            JoinNodeExpressionBuilder leftVisitor = new JoinNodeExpressionBuilder();
            JoinNodeExpressionBuilder rightVisitor = new JoinNodeExpressionBuilder();
            or.left().accept(leftVisitor);
            or.right().accept(rightVisitor);
            Expression leftExpr = leftVisitor.getExpression();
            Expression rightExpr = rightVisitor.getExpression();
            this.expression = Expressions.new_((Constructor)OR_CONSTRUCTOR, (Expression[])new Expression[]{leftExpr, rightExpr});
        }

        @Override
        public void visit(JoinAndNode and) {
            JoinNodeExpressionBuilder leftVisitor = new JoinNodeExpressionBuilder();
            JoinNodeExpressionBuilder rightVisitor = new JoinNodeExpressionBuilder();
            and.left().accept(leftVisitor);
            and.right().accept(rightVisitor);
            Expression leftExpr = leftVisitor.getExpression();
            Expression rightExpr = rightVisitor.getExpression();
            this.expression = Expressions.new_((Constructor)AND_CONSTRUCTOR, (Expression[])new Expression[]{leftExpr, rightExpr});
        }

        @Override
        public void visit(JoinGtNode gt) {
            this.expression = this.createBinaryExpression(gt, GT_CONSTRUCTOR);
        }

        @Override
        public void visit(JoinGtEqNode gtEq) {
            this.expression = this.createBinaryExpression(gtEq, GT_EQ_CONSTRUCTOR);
        }

        @Override
        public void visit(JoinLessNode less) {
            this.expression = this.createBinaryExpression(less, LESS_CONSTRUCTOR);
        }

        @Override
        public void visit(JoinLessEqNode lessEq) {
            this.expression = this.createBinaryExpression(lessEq, LESS_EQ_CONSTRUCTOR);
        }

        private NewExpression createBinaryExpression(JoinBinaryNode eq, Constructor constructor) {
            return Expressions.new_((Constructor)constructor, (Expression[])new Expression[]{Expressions.constant((Object)eq.leftField()), Expressions.constant((Object)eq.rightField())});
        }
    }
}

