/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rules;

import com.gigaspaces.jdbc.rel.InsightEdgeAggregate;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;

public class InsightEdgeAggregateRule
extends RelOptRule {
    private static final RelOptRule AGGREGATE_TABLESCAN_RULE = new InsightEdgeAggregateRule(InsightEdgeAggregateRule.operand(LogicalAggregate.class, (RelOptRuleOperand)InsightEdgeAggregateRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeAggregateRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeAggregateTableScanRule");
    private static final RelOptRule AGGREGATE_FILTER_TABLESCAN_RULE = new InsightEdgeAggregateRule(InsightEdgeAggregateRule.operand(LogicalAggregate.class, (RelOptRuleOperand)InsightEdgeAggregateRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeAggregateRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeAggregateRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeAggregateFilterTableScanRule");
    public static final RelOptRule[] RULES = new RelOptRule[]{AGGREGATE_TABLESCAN_RULE, AGGREGATE_FILTER_TABLESCAN_RULE};
    private final RelTrait inTrait = Convention.NONE;
    private final RelTrait outTrait = InsightEdgeRel.CONVENTION;
    private static final Set<SqlKind> supportedPushDownAggs = ImmutableSet.of((Object)SqlKind.SUM, (Object)SqlKind.SUM0, (Object)SqlKind.MIN, (Object)SqlKind.MAX, (Object)SqlKind.COUNT, (Object)SqlKind.AVG, (Object[])new SqlKind[0]);

    private InsightEdgeAggregateRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalAggregate logicalAggregate = (LogicalAggregate)call.rel(0);
        for (AggregateCall aggCall : logicalAggregate.getAggCallList()) {
            SqlKind kind = aggCall.getAggregation().getKind();
            if (supportedPushDownAggs.contains(kind)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        RelNode rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert(rel)) != null) {
            call.transformTo(converted);
        }
    }

    public RelNode convert(RelNode rel) {
        LogicalAggregate agg = (LogicalAggregate)rel;
        RelTraitSet traitSet = agg.getTraitSet().replace(this.outTrait);
        return new InsightEdgeAggregate(rel.getCluster(), traitSet, InsightEdgeAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet.simplify()), agg.indicator, agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
    }
}

