/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rules;

import com.gigaspaces.jdbc.rel.InsightEdgeFilter;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.gigaspaces.jdbc.rel.InsightEdgeTableScan;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;

public class InsightEdgeFilterRule
extends RelOptRule {
    public static final InsightEdgeFilterRule INSTANCE = new InsightEdgeFilterRule();
    private final RelTrait inTrait = Convention.NONE;
    private final RelTrait outTrait = InsightEdgeRel.CONVENTION;
    private static final Set<SqlKind> supportedOperators = ImmutableSet.of((Object)SqlKind.EQUALS, (Object)SqlKind.NOT_EQUALS, (Object)SqlKind.GREATER_THAN, (Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)SqlKind.LESS_THAN, (Object)SqlKind.LESS_THAN_OR_EQUAL, (Object[])new SqlKind[]{SqlKind.OR, SqlKind.AND, SqlKind.LIKE, SqlKind.NOT, SqlKind.IS_NULL, SqlKind.IS_NOT_NULL, SqlKind.CAST});

    private InsightEdgeFilterRule() {
        super(InsightEdgeFilterRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeFilterRule.operand(InsightEdgeTableScan.class, (RelOptRuleOperandChildren)InsightEdgeFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeFilterRule");
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        RexCall condition = (RexCall)filter.getCondition();
        return this.checkRexCallRecursively(condition);
    }

    private boolean checkRexCallRecursively(RexCall rexCall) {
        RexNode rexNode;
        SqlOperator operator = rexCall.getOperator();
        List operands = rexCall.getOperands();
        if (operator.getKind() == SqlKind.NOT && ((rexNode = (RexNode)operands.get(0)).getKind() == SqlKind.OR || rexNode.getKind() == SqlKind.AND)) {
            return false;
        }
        if (!supportedOperators.contains(operator.getKind())) {
            return false;
        }
        for (RexNode operand : operands) {
            SqlKind operandKind;
            boolean matches;
            if (!(operand instanceof RexCall ? !(matches = this.checkRexCallRecursively((RexCall)operand)) : (operandKind = operand.getKind()) != SqlKind.LITERAL && operandKind != SqlKind.INPUT_REF && operandKind != SqlKind.DYNAMIC_PARAM)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        RelNode rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert(rel)) != null) {
            call.transformTo(converted);
        }
    }

    public RelNode convert(RelNode rel) {
        LogicalFilter filter = (LogicalFilter)rel;
        RelTraitSet traitSet = filter.getTraitSet().replace(this.outTrait);
        return new InsightEdgeFilter(rel.getCluster(), traitSet, InsightEdgeFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.outTrait), filter.getCondition());
    }
}

