/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rules;

import com.gigaspaces.jdbc.rel.InsightEdgeJoin;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;

public class InsightEdgeJoinRule
extends RelOptRule {
    private static final InsightEdgeJoinRule TABLESCAN_JOIN_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none())}), "InsightEdgeTableScanJoinTableScan");
    private static final InsightEdgeJoinRule FILTER_TABLESCAN_JOIN_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none())}), "InsightEdgeFilterTableScanJoinTableScan");
    private static final InsightEdgeJoinRule PROJECT_TABLESCAN_JOIN_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none())}), "InsightEdgeProjectTableScanJoinTableScan");
    private static final InsightEdgeJoinRule PROJECT_FILTER_TABLESCAN_JOIN_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none())}), "InsightEdgeProjectFilterTableScanJoinTableScan");
    private static final InsightEdgeJoinRule FILTER_TABLESCAN_JOIN_FILTER_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0])}), "InsightEdgeFilterTableScanJoinFilterTableScan");
    private static final InsightEdgeJoinRule FILTER_TABLESCAN_JOIN_PROJECT_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0])}), "InsightEdgeFilterTableScanJoinProjectTableScan");
    private static final InsightEdgeJoinRule PROJECT_FILTER_TABLESCAN_JOIN_FILTER_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0])}), "InsightEdgeProjectFilterTableScanJoinFilterTableScan");
    private static final InsightEdgeJoinRule PROJECT_TABLESCAN_JOIN_PROJECT_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0])}), "InsightEdgeProjectTableScanJoinProjectTableScan");
    private static final InsightEdgeJoinRule PROJECT_FILTER_TABLESCAN_JOIN_PROJECT_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0])}), "InsightEdgeProjectFilterTableScanJoinProjectTableScan");
    private static final InsightEdgeJoinRule PROJECT_FILTER_TABLESCAN_JOIN_PROJECT_FILTER_TABLESCAN = new InsightEdgeJoinRule(InsightEdgeJoinRule.operand(LogicalJoin.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{InsightEdgeJoinRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeJoinRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeJoinRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0])}), "InsightEdgeProjectFilterTableScanJoinProjectFilterTableScan");
    public static final RelOptRule[] RULES = new RelOptRule[]{TABLESCAN_JOIN_TABLESCAN, FILTER_TABLESCAN_JOIN_TABLESCAN, PROJECT_TABLESCAN_JOIN_TABLESCAN, PROJECT_FILTER_TABLESCAN_JOIN_TABLESCAN, FILTER_TABLESCAN_JOIN_FILTER_TABLESCAN, FILTER_TABLESCAN_JOIN_PROJECT_TABLESCAN, PROJECT_FILTER_TABLESCAN_JOIN_FILTER_TABLESCAN, PROJECT_TABLESCAN_JOIN_PROJECT_TABLESCAN, PROJECT_FILTER_TABLESCAN_JOIN_PROJECT_TABLESCAN, PROJECT_FILTER_TABLESCAN_JOIN_PROJECT_FILTER_TABLESCAN};
    private static final Set<SqlKind> SUPPORTED_JOIN_COND_KINDS = ImmutableSet.of((Object)SqlKind.EQUALS, (Object)SqlKind.AND, (Object)SqlKind.OR, (Object)SqlKind.INPUT_REF, (Object)SqlKind.GREATER_THAN, (Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object[])new SqlKind[]{SqlKind.LESS_THAN, SqlKind.LESS_THAN_OR_EQUAL});
    private final RelTrait inTrait = Convention.NONE;
    private final RelTrait outTrait = InsightEdgeRel.CONVENTION;

    private InsightEdgeJoinRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        if (join.getJoinType() != JoinRelType.INNER && join.getJoinType() != JoinRelType.LEFT && join.getJoinType() != JoinRelType.RIGHT) {
            return false;
        }
        RexNode condition = join.getCondition();
        return this.rexNodeMatches(condition);
    }

    private boolean rexNodeMatches(RexNode rexNode) {
        SqlKind kind = rexNode.getKind();
        if (!SUPPORTED_JOIN_COND_KINDS.contains(kind)) {
            return false;
        }
        if (rexNode instanceof RexCall) {
            RexCall call = (RexCall)rexNode;
            List operands = call.getOperands();
            for (RexNode operand : operands) {
                if (this.rexNodeMatches(operand)) continue;
                return false;
            }
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        RelNode rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert(rel)) != null) {
            call.transformTo(converted);
        }
    }

    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        RelTraitSet traitSet = join.getTraitSet().replace(this.outTrait);
        return new InsightEdgeJoin(rel.getCluster(), traitSet, InsightEdgeJoinRule.convert((RelNode)join.getLeft(), (RelTrait)this.outTrait), InsightEdgeJoinRule.convert((RelNode)join.getRight(), (RelTrait)this.outTrait), join.getCondition(), join.getVariablesSet(), join.getJoinType());
    }
}

