/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rules;

import com.gigaspaces.jdbc.rel.InsightEdgeProject;
import com.gigaspaces.jdbc.rel.InsightEdgeRel;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;

public class InsightEdgeProjectRule
extends RelOptRule {
    private static final InsightEdgeProjectRule PROJECT_TABLESCAN = new InsightEdgeProjectRule(InsightEdgeProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeProjectTableScanRule");
    private static final InsightEdgeProjectRule PROJECT_AGGREGATE = new InsightEdgeProjectRule(InsightEdgeProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(Aggregate.class, (RelOptRuleOperandChildren)InsightEdgeProjectRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeProjectAggregateRule");
    private static final InsightEdgeProjectRule PROJECT_SORT_TABLESCAN = new InsightEdgeProjectRule(InsightEdgeProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(LogicalSort.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeProjectSortTableScanRule");
    private static final InsightEdgeProjectRule PROJECT_FILTER_TABLESCAN = new InsightEdgeProjectRule(InsightEdgeProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeProjectFilterTableScanRule");
    private static final InsightEdgeProjectRule PROJECT_SORT_FILTER_TABLESCAN = new InsightEdgeProjectRule(InsightEdgeProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(LogicalSort.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(LogicalFilter.class, (RelOptRuleOperand)InsightEdgeProjectRule.operand(TableScan.class, (RelOptRuleOperandChildren)InsightEdgeProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "InsightEdgeProjectSortFilterTableScanRule");
    public static final RelOptRule[] RULES = new RelOptRule[]{PROJECT_TABLESCAN, PROJECT_AGGREGATE, PROJECT_SORT_TABLESCAN, PROJECT_FILTER_TABLESCAN, PROJECT_SORT_FILTER_TABLESCAN};
    private final RelTrait inTrait = Convention.NONE;
    private final RelTrait outTrait = InsightEdgeRel.CONVENTION;

    private InsightEdgeProjectRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        for (RexNode e : project.getProjects()) {
            if (e instanceof RexInputRef) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode converted;
        RelNode rel = call.rel(0);
        if (rel.getTraitSet().contains(this.inTrait) && (converted = this.convert(rel)) != null) {
            call.transformTo(converted);
        }
    }

    public RelNode convert(RelNode rel) {
        LogicalProject project = (LogicalProject)rel;
        RelTraitSet traitSet = project.getTraitSet().replace(this.outTrait);
        return new InsightEdgeProject(project.getCluster(), traitSet, InsightEdgeProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.outTrait), project.getProjects(), project.getRowType());
    }
}

