/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc.rules;

import com.gigaspaces.jdbc.rules.InsightEdgeAggregateRule;
import com.gigaspaces.jdbc.rules.InsightEdgeFilterRule;
import com.gigaspaces.jdbc.rules.InsightEdgeJoinRule;
import com.gigaspaces.jdbc.rules.InsightEdgeProjectRule;
import com.gigaspaces.jdbc.rules.InsightEdgeSortRule;
import com.gigaspaces.jdbc.rules.InsightEdgeToEnumerableConverterRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexVisitorImpl;

public class InsightEdgeRules {
    public static List<RelOptRule> allRules(boolean disableServerSideJoins) {
        ArrayList<RelOptRule> list = new ArrayList<RelOptRule>();
        list.add((RelOptRule)InsightEdgeToEnumerableConverterRule.INSTANCE);
        list.add(InsightEdgeFilterRule.INSTANCE);
        list.addAll(Arrays.asList(InsightEdgeAggregateRule.RULES));
        list.addAll(Arrays.asList(InsightEdgeProjectRule.RULES));
        list.addAll(Arrays.asList(InsightEdgeSortRule.RULES));
        if (!disableServerSideJoins) {
            list.addAll(Arrays.asList(InsightEdgeJoinRule.RULES));
        }
        return list;
    }

    private InsightEdgeRules() {
    }

    public static List<String> insightEdgeFieldNames(RelDataType rowType) {
        return rowType.getFieldNames();
    }

    public static class RexToInsightEdgeTranslator
    extends RexVisitorImpl<String> {
        private final List<String> inFields;

        public RexToInsightEdgeTranslator(List<String> inFields) {
            super(true);
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }
    }
}

