/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.gigaspaces.jdbc.InsightEdgeSchemaFactory;
import com.j_spaces.core.client.SpaceURLParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.HandlerImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.util.JsonBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class InsightEdgeModelHandler
extends HandlerImpl {
    public static final String OPERAND_SPACE_URL = "spaceUrl";
    public static final String OPERAND_TIME_ZONE = "timeZone";
    private static final String CONN_PROP_LOG_LEVEL = "logLevel";
    private static final String CONN_PROP_LOG4JFILE = "log4jFile";
    private static final String CONN_PROP_AUTO_COMMIT = "autoCommit";
    private static final String CONN_PROP_QUOTING = "quoting";
    public static final String AUTO_COMMIT_SYSTEM_PROP = "com.gigaspaces.jdbc.autoCommit";
    private static final String DEFAULT_LEXER = "JAVA";

    public void onConnectionInit(AvaticaConnection avaticaConnection) throws SQLException {
        CalciteConnectionImpl connection = (CalciteConnectionImpl)avaticaConnection;
        super.onConnectionInit(avaticaConnection);
        Properties connProperties = connection.getProperties();
        Properties connProps = this.overrideLoggingConfiguration(connProperties);
        this.setDefaultLexer(connProps);
        this.setAutoCommit(connProps, connection);
        this.setQuotingProperty(connProps);
        String model = this.buildJsonStringModel(connProps);
        try {
            new ModelHandler((CalciteConnection)connection, model);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        connection.init();
    }

    private static RuntimeException ambiguous(String s1, String s2) {
        return new RuntimeException("Ambiguous configuration: '" + s1 + "' and '" + s2 + "' cannot be used together");
    }

    private String buildJsonStringModel(Properties connProps) {
        String timeZone;
        String name = connProps.getProperty("spaceName", "");
        String spaceUrl = connProps.getProperty("url", "");
        if (!name.isEmpty()) {
            if (!spaceUrl.isEmpty() && !spaceUrl.contains("spaceName")) {
                throw InsightEdgeModelHandler.ambiguous("url", "spaceName");
            }
            spaceUrl = "";
        } else {
            if (spaceUrl.isEmpty()) {
                throw new RuntimeException("Invalid configuration: either 'spaceName' or 'url' must be set");
            }
            name = this.extractSpaceNameFromUrl(spaceUrl);
            connProps.setProperty("spaceName", name);
        }
        JsonBuilder json = new JsonBuilder();
        Map root = json.map();
        root.put("version", "1.0");
        root.put("defaultSchema", name);
        List schemaList = json.list();
        root.put("schemas", schemaList);
        Map schema = json.map();
        schemaList.add(schema);
        schema.put("type", "custom");
        schema.put("name", name);
        schema.put("factory", InsightEdgeSchemaFactory.class.getName());
        Map operandMap = json.map();
        schema.put("operand", operandMap);
        operandMap.put("spaceName", name);
        if (!spaceUrl.isEmpty()) {
            operandMap.put(OPERAND_SPACE_URL, spaceUrl);
        }
        if (connProps.containsKey("user")) {
            operandMap.put("user", connProps.get("user"));
        }
        if (connProps.containsKey("password")) {
            operandMap.put("password", connProps.get("password"));
        }
        if (connProps.containsKey("disableServerSideJoins")) {
            operandMap.put("disableServerSideJoins", connProps.get("disableServerSideJoins"));
        }
        if (connProps.containsKey("preferSpaceIterator")) {
            operandMap.put("preferSpaceIterator", connProps.get("preferSpaceIterator"));
        }
        if ((timeZone = BuiltInConnectionProperty.TIME_ZONE.wrap(connProps).getString()) != null) {
            operandMap.put(OPERAND_TIME_ZONE, timeZone);
        }
        return "inline:" + json.toJsonString((Object)root);
    }

    private void setDefaultLexer(Properties connProps) {
        if (!connProps.containsKey(CalciteConnectionProperty.LEX.camelName())) {
            connProps.put(CalciteConnectionProperty.LEX.camelName(), DEFAULT_LEXER);
        }
    }

    private void setAutoCommit(Properties connProps, CalciteConnectionImpl connection) throws SQLException {
        String autoCommit = connProps.getProperty(CONN_PROP_AUTO_COMMIT);
        if (autoCommit == null) {
            autoCommit = System.getProperty(AUTO_COMMIT_SYSTEM_PROP);
        }
        if (autoCommit != null) {
            connection.setAutoCommit(Boolean.parseBoolean(autoCommit));
        }
    }

    private String extractSpaceNameFromUrl(String spaceUrl) {
        try {
            return SpaceURLParser.parseURL((String)spaceUrl).getSpaceName();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to parse URL " + spaceUrl);
        }
    }

    private Properties overrideLoggingConfiguration(Properties connProps) {
        if (connProps.containsKey(CONN_PROP_LOG4JFILE)) {
            String log4jFile = connProps.getProperty(CONN_PROP_LOG4JFILE);
            PropertyConfigurator.configure((String)log4jFile);
        }
        if (connProps.containsKey(CONN_PROP_LOG_LEVEL)) {
            String logLevel = connProps.getProperty(CONN_PROP_LOG_LEVEL);
            LogManager.getLogger((String)"com.gigaspaces.jdbc").setLevel(Level.toLevel((String)logLevel));
        }
        return connProps;
    }

    private void setQuotingProperty(Properties connProps) {
        connProps.setProperty(CONN_PROP_QUOTING, connProps.getProperty(CONN_PROP_QUOTING, "DOUBLE_QUOTE"));
    }
}

