/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.interop.dotnet.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.persistencyenumerator.EnumeratorNextBatch;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DotNetDataIterator
extends DispatcherObjectProxy
implements DataIterator<IEntryPacket> {
    private static Logger _logger;
    private int _batchSize;
    private List<IEntryPacket> _batch;
    private Iterator<IEntryPacket> _batchIterator;
    private boolean _lastBatch;

    public DotNetDataIterator(long handleId, int contextAppDomainId, boolean handleInjected, int batchSize) {
        super((byte)7, handleId, contextAppDomainId, handleInjected, true);
        this._batchSize = batchSize;
        this._lastBatch = false;
        this.initLogger();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Iterator " + this.getHandleId() + " created");
        }
    }

    private void initLogger() {
        if (_logger == null) {
            GSLogConfigLoader.getLoader();
            _logger = Logger.getLogger("com.gigaspaces.externaldatasource.dotnet");
        }
    }

    public void close() {
        if (!this.isDisposed) {
            this.dispose();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Iterator " + this.getHandleId() + " closed");
            }
        }
    }

    public boolean hasNext() {
        if (!(this._batch != null && this._batchIterator.hasNext() || this._lastBatch)) {
            this.retrieveBatch();
        }
        return this._batchIterator.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public IEntryPacket next() {
        if (!(this._batch != null && this._batchIterator.hasNext() || this._lastBatch)) {
            this.retrieveBatch();
        }
        return this._batchIterator.next();
    }

    private void retrieveBatch() {
        this._batch = EnumeratorNextBatch.execute(this, this._batchSize);
        if (this._batch != null) {
            this._batchIterator = this._batch.iterator();
            if (this._batch.size() < this._batchSize) {
                this._lastBatch = true;
            }
        } else {
            this._lastBatch = true;
        }
    }
}

