/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.interop.dotnet.datasource;

import com.gigaspaces.datasource.BulkDataPersister;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.SQLDataProvider;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.interop.dotnet.datasource.DotNetDataIterator;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.serialization.pbs.commands.ConstructableDispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.persistency.Construct;
import com.gigaspaces.serialization.pbs.commands.persistency.EnumeratorQuery;
import com.gigaspaces.serialization.pbs.commands.persistency.ExecuteBulk;
import com.gigaspaces.serialization.pbs.commands.persistency.Init;
import com.gigaspaces.serialization.pbs.commands.persistency.InitialLoad;
import com.gigaspaces.serialization.pbs.commands.persistency.Shutdown;
import com.j_spaces.core.client.SQLQuery;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DotNetDataSourceAdapter
extends ConstructableDispatcherObjectProxy
implements SQLDataProvider<IEntryPacket>,
BulkDataPersister {
    private static Logger _logger;
    public static final String ConfigFileProperty = "dotnet-config-file";
    public static final String IteratorBatchSizeProperty = "iterator-batch-size";
    public static final String ImplementationNameProperty = "dotnet-implementation-name";
    public static final String AssemblyFileProperty = "dotnet-assembly-file";
    public static final String DependenciesProperty = "dotnet-dependencies-files";
    private int iteratorBatchSize = 10000;
    private String configFile;

    public DotNetDataSourceAdapter(long dotnetEdsHandleId, int contextAppDomainId, Properties customProperties) {
        super((byte)0, dotnetEdsHandleId, contextAppDomainId);
        this.setCustomProperties(customProperties);
        this.initLogger();
        _logger.log(Level.FINEST, ".Net SqlDataSource instance with handle id " + this.getHandleId() + " was injected");
    }

    public DotNetDataSourceAdapter() {
        super((byte)0);
        this.initLogger();
    }

    private void initLogger() {
        if (_logger == null) {
            GSLogConfigLoader.getLoader();
            _logger = Logger.getLogger("com.gigaspaces.externaldatasource.dotnet");
        }
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setIteratorBatchSize(int size) {
        this.iteratorBatchSize = size;
    }

    public DataIterator<IEntryPacket> iterator(SQLQuery<IEntryPacket> query) throws DataSourceException {
        try {
            long iteratorId = EnumeratorQuery.execute(this, query);
            return new DotNetDataIterator(iteratorId, this.contextAppDomainId, this.handleInjected, this.iteratorBatchSize);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public void init(Properties prop) throws DataSourceException {
        if (!this.handleInjected) {
            String configFilePath = null;
            if (this.configFile == null) {
                configFilePath = prop.getProperty(ConfigFileProperty);
            } else {
                _logger.log(Level.FINEST, ".Net config file path was injected.");
                configFilePath = this.configFile;
            }
            if (configFilePath == null) {
                if (this.implementationName == null) {
                    this.implementationName = prop.getProperty(ImplementationNameProperty);
                    if (this.implementationName == null) {
                        throw new DataSourceException("No .Net SqlDataSource implementation Type name given, use dotnet-implementation-name in the properties file or inject it with the appropriate setter.");
                    }
                    _logger.log(Level.FINEST, ".Net SqlDataSource implementation type name taken from properties file.");
                } else {
                    _logger.log(Level.FINEST, ".Net SqlDataSource implementation type name was injected.");
                }
                if (this.assemblyFile == null) {
                    this.assemblyFile = prop.getProperty(AssemblyFileProperty);
                    if (this.assemblyFile == null) {
                        throw new DataSourceException("No .Net Assembly file containing the SqlDataSource implementation given, use dotnet-assembly-file in the properties file or inject it with the appropriate setter.");
                    }
                    _logger.log(Level.FINEST, ".Net assembly file that contains the SqlDataSource implementation taken from properties file.");
                } else {
                    _logger.log(Level.FINEST, ".Net assembly file that contains the SqlDataSource implementation was injected.");
                }
                if (this.dependencies == null) {
                    String dependenciesFromProp = prop.getProperty(DependenciesProperty);
                    if (dependenciesFromProp != null) {
                        this.dependencies = dependenciesFromProp.split(",");
                        _logger.log(Level.FINEST, ".Net additional dependencies needed for SqlDataSource taken from properties file.");
                    }
                } else {
                    _logger.log(Level.FINEST, ".Net additional dependencies needed for SqlDataSource were injected.");
                }
            }
            try {
                if (configFilePath != null) {
                    _logger.log(Level.FINE, "Constructing .Net SqlDataSource provider using .Net config file.");
                    this.setHandleId(Construct.execute(this, configFilePath));
                }
                _logger.log(Level.FINE, "Constructing .Net SqlDataSource provider without using .Net config file.");
                this.setHandleId(Construct.execute(this, this.implementationName, this.assemblyFile, this.dependencies));
            }
            catch (Exception e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            _logger.log(Level.FINEST, "An existing .Net SqlDataSource instance was injected, skipped construction step");
        }
        try {
            String batchSize;
            if (this.customProperties != null) {
                _logger.log(Level.FINEST, "Adding additional injected custom properties to the .Net SqlDataSource provider init.");
                prop.putAll((Map<?, ?>)this.customProperties);
            }
            if ((batchSize = prop.getProperty(IteratorBatchSizeProperty)) != null) {
                try {
                    this.iteratorBatchSize = Integer.parseInt(batchSize);
                    if (this.iteratorBatchSize < 1) {
                        throw new IllegalArgumentException("Iterator batch size must be a non negative integer number.");
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Iterator batch size can't be null value and must be a non negative integer.", e);
                }
                _logger.log(Level.FINEST, "Iterator batch size updated to " + batchSize + ".");
            }
            _logger.log(Level.FINE, "Initializing .Net SqlDataSource provider");
            Init.execute(this, prop);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public DataIterator<IEntryPacket> initialLoad() throws DataSourceException {
        try {
            long iteratorKey = InitialLoad.execute(this);
            return new DotNetDataIterator(iteratorKey, this.contextAppDomainId, this.handleInjected, this.iteratorBatchSize);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public void shutdown() throws DataSourceException {
        try {
            Shutdown.execute(this);
            if (!this.handleInjected) {
                this.dispose();
            }
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public void executeBulk(List<BulkItem> bulk) throws DataSourceException {
        try {
            ExecuteBulk.execute(this, bulk);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }
}

