/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.interop.dotnet.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.interop.dotnet.datasource.DotNetDataIterator;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.persistency.Init;
import com.gigaspaces.serialization.pbs.commands.persistency.InitialLoad;
import com.gigaspaces.serialization.pbs.commands.persistency.Shutdown;
import java.util.Map;
import java.util.Properties;

public class DotNetManagedDataSourceAdapter
extends DispatcherObjectProxy
implements ManagedDataSource<IEntryPacket> {
    private Properties customProperties;

    public DotNetManagedDataSourceAdapter(long handleId, int contextAppDomainId, Properties customProperties) {
        super((byte)0, handleId, contextAppDomainId);
        this.customProperties = customProperties;
    }

    public void init(Properties prop) throws DataSourceException {
        try {
            prop.putAll((Map<?, ?>)this.customProperties);
            Init.execute(this, prop);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public DataIterator<IEntryPacket> initialLoad() throws DataSourceException {
        try {
            long iteratorKey = InitialLoad.execute(this);
            return new DotNetDataIterator(iteratorKey, this.contextAppDomainId, true, 10000);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }

    public void shutdown() throws DataSourceException {
        try {
            Shutdown.execute(this);
        }
        catch (Exception e) {
            throw new DataSourceException((Throwable)e);
        }
    }
}

