/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.interop.dotnet.filters;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.serialization.pbs.commands.ConstructableDispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.spacefilter.Construct;
import com.gigaspaces.serialization.pbs.commands.spacefilter.Init;
import com.gigaspaces.serialization.pbs.commands.spacefilter.ProcessOneEntry;
import com.gigaspaces.serialization.pbs.commands.spacefilter.ProcessTwoEntries;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DotNetSpaceFilterAdapter
extends ConstructableDispatcherObjectProxy
implements ISpaceFilter {
    private static Logger _logger;
    private long proxyHandleId;
    private static final String INCORRECT_URL_FORMAT_MESSAGE = "url argument must be of format: <Implementation Full Type Name>;<Implementation assembly>;<Optional - Additional dependencies separated by ','>;<Optional - custom properties separated by ',' (key1,value1,key2,value2...)>";

    public DotNetSpaceFilterAdapter(long handleId, int contextAppDomain, Properties customProperties) {
        super((byte)2, handleId, contextAppDomain);
        this.customProperties = customProperties;
        this.initLogger();
        _logger.log(Level.FINEST, ".Net SpaceFilter instance with handle id " + this.getHandleId() + " was injected");
    }

    public DotNetSpaceFilterAdapter() {
        super((byte)2);
        this.initLogger();
    }

    private void initLogger() {
        if (_logger == null) {
            GSLogConfigLoader.getLoader();
            _logger = Logger.getLogger("com.gigaspaces.spacefilter.dotnet");
        }
    }

    public void close() {
        _logger.log(Level.FINE, "Closing .Net SpaceFilter");
        this.dispose();
        PbsExecuter.ISpaceProxyBundle.removeInstance(this.proxyHandleId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IJSpace space, String filterId, String url, int priority) {
        if (!this.handleInjected) {
            if (this.assemblyFile == null || this.implementationName == null) {
                _logger.log(Level.FINEST, "Taking .Net SpaceFilter properties from url property");
                String[] arguments = url.split(";");
                if (arguments.length < 2) {
                    throw new IllegalArgumentException(INCORRECT_URL_FORMAT_MESSAGE);
                }
                this.implementationName = arguments[0];
                this.assemblyFile = arguments[1];
                this.dependencies = null;
                if (arguments.length >= 3) {
                    String[] tempDependencies = arguments[2].split(",");
                    ArrayList<String> actualDependencies = new ArrayList<String>();
                    for (int i = 0; i < tempDependencies.length; ++i) {
                        if (tempDependencies[i].equals("")) continue;
                        actualDependencies.add(tempDependencies[i]);
                    }
                    this.dependencies = new String[actualDependencies.size()];
                    this.dependencies = actualDependencies.toArray(this.dependencies);
                }
                if (arguments.length != 4) throw new IllegalArgumentException(INCORRECT_URL_FORMAT_MESSAGE);
                String[] customPropsStr = arguments[3].split(",");
                if (customPropsStr.length % 2 != 0) {
                    throw new IllegalArgumentException(INCORRECT_URL_FORMAT_MESSAGE);
                }
                if (this.customProperties == null) {
                    this.customProperties = new Properties();
                }
                for (int i = 0; i < customPropsStr.length; i += 2) {
                    this.customProperties.put(customPropsStr[i], customPropsStr[i + 1]);
                }
            } else {
                _logger.log(Level.FINEST, "An existing .Net SpaceFilter instance was injected, skipped construction step");
            }
            _logger.log(Level.FINE, "Constructing .Net SpaceFilter");
            long handleId = Construct.execute(this, this.implementationName, this.assemblyFile, this.dependencies);
            this.setHandleId(handleId);
        } else {
            _logger.log(Level.FINEST, "An existing .Net SpaceFilter instance was injected, skipped construction step");
        }
        _logger.log(Level.FINE, "Initializing .Net SpaceFilter");
        this.proxyHandleId = Init.execute(this, (ISpaceProxy)space, filterId, this.customProperties, priority);
    }

    public void process(SpaceContext context, ISpaceFilterEntry entry, int operationCode) {
        if (operationCode != 51) {
            ProcessOneEntry.execute(this, context, entry, operationCode);
        }
    }

    public void process(SpaceContext context, ISpaceFilterEntry[] entries, int operationCode) {
        if (entries.length != 2) {
            throw new IllegalArgumentException("process method ISpaceFilterEntry[] entries size must be 2, received size " + entries.length);
        }
        ProcessTwoEntries.execute(this, context, entries[0], entries[1], operationCode);
    }
}

