/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PbsAuditor {
    private static final byte LEVEL_OFF = 0;
    private static final byte LEVEL_ON = 1;
    private static final byte LEVEL_VERBOSE = 2;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.bridge.pbsexecuter");
    private final String _name;
    private final byte _enterLevel;
    private final AtomicInteger _enterCounter;
    private final byte _errorLevel;
    private final AtomicInteger _errorCounter;
    private final byte _exitLevel;
    private final AtomicInteger _exitCounter;

    public PbsAuditor(String name) {
        this._name = name;
        this._enterLevel = PbsAuditor.initLevel(name, "Enter");
        this._enterCounter = this._enterLevel == 0 ? null : new AtomicInteger();
        this._errorLevel = PbsAuditor.initLevel(name, "Error");
        this._errorCounter = this._errorLevel == 0 ? null : new AtomicInteger();
        this._exitLevel = PbsAuditor.initLevel(name, "Exit");
        this._exitCounter = this._exitLevel == 0 ? null : new AtomicInteger();
    }

    public void logEnter() {
        if (this._enterLevel != 0) {
            int current = this._enterCounter.incrementAndGet();
            if (this._enterLevel == 2 && _logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Auditor [" + this._name + "] Enter = " + current);
            }
        }
    }

    public void logError() {
        if (this._errorLevel != 0) {
            int current = this._errorCounter.incrementAndGet();
            if (this._errorLevel == 2 && _logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Auditor [" + this._name + "] Error = " + current);
            }
        }
    }

    public void logExit() {
        if (this._exitLevel != 0) {
            int current = this._exitCounter.incrementAndGet();
            if (this._exitLevel == 2 && _logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Auditor [" + this._name + "] Exit = " + current);
            }
        }
    }

    private static byte initLevel(String name, String eventType) {
        String key = "com.gigaspaces.pbs." + name + "." + eventType;
        String value = System.getProperty(key);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Illegal value [" + value + "] for property " + key + " - should be numeric.");
            }
            return 0;
        }
    }
}

