/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs;

import com.gigaspaces.client.ClearException;
import com.gigaspaces.client.ReadMultipleException;
import com.gigaspaces.client.TakeMultipleException;
import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.gigaspaces.cluster.replication.RedoLogCapacityExceededException;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.DotNetException;
import com.gigaspaces.serialization.pbs.commands.JavaToNetException;
import com.gigaspaces.serialization.pbs.executers.ObjectDisposedOrDoesntExistException;
import com.j_spaces.core.DetailedUnusableEntryException;
import com.j_spaces.core.DropClassException;
import com.j_spaces.core.MemoryShortageException;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.sql.SQLQueryException;
import com.j_spaces.core.exception.SpaceAlreadyStartedException;
import com.j_spaces.core.exception.SpaceAlreadyStoppedException;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;

public class PbsExceptionFormatter {
    public static final short Success = 0;
    public static final short GeneralException = 1;
    public static final short OutgoingNoSuchElementException = 64;
    public static final short OutgoingLeaseDeniedException = 65;
    public static final short OutgoingUnknownLeaseException = 66;
    public static final short OutgoingCannotCommitException = 67;
    public static final short OutgoingUnknownTransactionException = 68;
    public static final short OutgoingTimeoutExpiredException = 69;
    public static final short OutgoingCannotAbortException = 70;
    public static final short OutgoingTransactionException = 71;
    public static final short OutgoingEntryAlreadyInSpaceException = 72;
    public static final short OutgoingFinderException = 73;
    public static final short OutgoingUnusableEntryException = 74;
    public static final short OutgoingDropClassException = 75;
    public static final short OutgoingEntryVersionConflictException = 76;
    public static final short OutgoingEntryNotInSpaceException = 77;
    public static final short OutgoingUnknownTypeException = 78;
    public static final short OutgoingMemoryShortageException = 79;
    public static final short OutgoingDetailedUnusableEntryException = 80;
    public static final short OutgoingOperationTimeoutException = 81;
    public static final short OutgoingSecurityException = 82;
    public static final short OutgoingSpaceAlreadyStartedException = 83;
    public static final short OutgoingSpaceAlreadyStoppedException = 84;
    public static final short OutgoingInactiveSpaceException = 85;
    public static final short OutgoingObjectDisposedOrDoesntExistException = 86;
    public static final short OutgoingSQLQueryException = 87;
    public static final short OutgoingJvmOutOfMemoryException = 88;
    public static final short OutgoingReadMultipleException = 89;
    public static final short OutgoingTakeMultipleException = 90;
    public static final short OutgoingClearException = 91;
    public static final short OutgoingRedoLogCapacityExceededException = 92;
    public static final short OutgoingCannotJoinException = 93;
    public static final short OutgoingNativeException = 127;
    public static final short OutgoingJavaToNetException = 128;
    private static HashMap<Class<?>, Short> exceptionCodes = PbsExceptionFormatter.loadExceptionCodes();

    private static HashMap<Class<?>, Short> loadExceptionCodes() {
        HashMap table = new HashMap();
        table.put(NoSuchElementException.class, (short)64);
        table.put(LeaseDeniedException.class, (short)65);
        table.put(UnknownLeaseException.class, (short)66);
        table.put(CannotCommitException.class, (short)67);
        table.put(UnknownTransactionException.class, (short)68);
        table.put(TimeoutExpiredException.class, (short)69);
        table.put(CannotAbortException.class, (short)70);
        table.put(TransactionException.class, (short)71);
        table.put(EntryAlreadyInSpaceException.class, (short)72);
        table.put(FinderException.class, (short)73);
        table.put(UnusableEntryException.class, (short)74);
        table.put(DropClassException.class, (short)75);
        table.put(EntryVersionConflictException.class, (short)76);
        table.put(EntryNotInSpaceException.class, (short)77);
        table.put(UnknownTypeException.class, (short)78);
        table.put(MemoryShortageException.class, (short)79);
        table.put(DetailedUnusableEntryException.class, (short)80);
        table.put(OperationTimeoutException.class, (short)81);
        table.put(SecurityException.class, (short)82);
        table.put(SpaceAlreadyStartedException.class, (short)83);
        table.put(SpaceAlreadyStoppedException.class, (short)84);
        table.put(InactiveSpaceException.class, (short)85);
        table.put(ObjectDisposedOrDoesntExistException.class, (short)86);
        table.put(JavaToNetException.class, (short)128);
        table.put(SQLQueryException.class, (short)87);
        table.put(OutOfMemoryError.class, (short)88);
        table.put(ReadMultipleException.class, (short)89);
        table.put(TakeMultipleException.class, (short)90);
        table.put(ClearException.class, (short)91);
        table.put(RedoLogCapacityExceededException.class, (short)92);
        table.put(CannotJoinException.class, (short)93);
        return table;
    }

    private static short getExceptionCode(Throwable e) {
        Short exceptionCode = exceptionCodes.get(e.getClass());
        if (exceptionCode == null) {
            return 1;
        }
        return exceptionCode;
    }

    private static Throwable identifyException(Throwable e) {
        Throwable result = PbsExceptionFormatter.identifyExceptionHelper(e);
        if (result == null) {
            return e;
        }
        return result;
    }

    private static Throwable identifyExceptionHelper(Throwable e) {
        if (e == null) {
            return null;
        }
        short code = PbsExceptionFormatter.getExceptionCode(e);
        if (code != 1) {
            return e;
        }
        return PbsExceptionFormatter.identifyExceptionHelper(e.getCause());
    }

    public static void checkException(PbsInputStream reader) {
        short code = reader.readShort();
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                DotNetException exception = PbsExceptionFormatter.readUnspecifiedException(reader);
                PbsStreamResource.releasePbsStream((IThreadLocalResource)reader);
                throw exception;
            }
            default: {
                PbsStreamResource.releasePbsStream((IThreadLocalResource)reader);
                throw new PBSInternalSpaceException("Pbs Format error, received unknown error code " + code);
            }
        }
    }

    private static DotNetException readUnspecifiedException(PbsInputStream reader) {
        String name = reader.readString();
        String message = reader.readString();
        String stackTrace = reader.readString();
        DotNetException innerException = null;
        boolean hasInnerException = reader.readBoolean();
        if (hasInnerException) {
            innerException = PbsExceptionFormatter.readUnspecifiedException(reader);
        }
        return new DotNetException(name, message, stackTrace, innerException);
    }

    public static void writeException(PbsOutputStream output, Throwable e, short exceptionCode, boolean resetStream) {
        if (resetStream) {
            output.reset();
        }
        if (exceptionCode == 1) {
            Throwable identifiedException = PbsExceptionFormatter.identifyException(e);
            exceptionCode = PbsExceptionFormatter.getExceptionCode(identifiedException);
            e = identifiedException;
        }
        output.writeShort(exceptionCode);
        switch (exceptionCode) {
            case 0: {
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 93: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                break;
            }
            case 79: {
                PbsExceptionFormatter.writeExceptionInternal(output, e, false, true, false, false);
                MemoryShortageException memException = (MemoryShortageException)e;
                output.writeString(memException.getHostName());
                output.writeString(memException.getContainerName());
                output.writeString(memException.getSpaceName());
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                break;
            }
            case 85: {
                PbsExceptionFormatter.writeExceptionInternal(output, e, false, true, false, false);
                InactiveSpaceException inactiveSpaceException = (InactiveSpaceException)e;
                output.writeString(inactiveSpaceException.getPrimarySpaceName());
                output.writeString(inactiveSpaceException.getInActiveSpaceName());
                break;
            }
            case 86: {
                PbsExceptionFormatter.writeExceptionNoInternalNoStackTrace(output, e);
                ObjectDisposedOrDoesntExistException disposedException = (ObjectDisposedOrDoesntExistException)e;
                output.writeByte(disposedException.getBundleCode());
                output.writeLong(disposedException.getHandleId());
                break;
            }
            case 87: 
            case 88: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                break;
            }
            case 89: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                ReadMultipleException readMultipleException = (ReadMultipleException)e;
                Object[] results = readMultipleException.getResults();
                Throwable[] causes = readMultipleException.getCauses();
                PbsEntryFormatter.writePbsEntryPacketObjectArray((PbsOutputStream)output, (Object[])results);
                if (causes == null) {
                    output.writeInt(-1);
                    break;
                }
                output.writeInt(causes.length);
                for (int i = 0; i < causes.length; ++i) {
                    PbsExceptionFormatter.writeException(output, causes[i], (short)1, false);
                }
                break;
            }
            case 90: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                TakeMultipleException takeMultipleException = (TakeMultipleException)e;
                Object[] results = takeMultipleException.getResults();
                Throwable[] causes = takeMultipleException.getCauses();
                PbsEntryFormatter.writePbsEntryPacketObjectArray((PbsOutputStream)output, (Object[])results);
                if (causes == null) {
                    output.writeInt(-1);
                    break;
                }
                output.writeInt(causes.length);
                for (int i = 0; i < causes.length; ++i) {
                    PbsExceptionFormatter.writeException(output, causes[i], (short)1, false);
                }
                break;
            }
            case 91: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                ClearException clearException = (ClearException)e;
                Throwable[] causes = clearException.getCauses();
                if (causes == null) {
                    output.writeInt(-1);
                    break;
                }
                output.writeInt(causes.length);
                for (int i = 0; i < causes.length; ++i) {
                    PbsExceptionFormatter.writeException(output, causes[i], (short)1, false);
                }
                break;
            }
            case 92: {
                PbsExceptionFormatter.writeExceptionInternal(output, e, false, true, false, false);
                RedoLogCapacityExceededException redoLogCapEx = (RedoLogCapacityExceededException)e;
                output.writeString(redoLogCapEx.getSpaceName());
                output.writeString(redoLogCapEx.getTargetName());
                break;
            }
            case 128: {
                PbsExceptionFormatter.writeExceptionWithInternalWithStackTrace(output, e);
                break;
            }
            default: {
                PbsExceptionFormatter.writeExceptionInternal(output, e, true, true, true, true);
            }
        }
    }

    private static void writeExceptionWithInternalWithStackTrace(PbsOutputStream output, Throwable e) {
        PbsExceptionFormatter.writeExceptionInternal(output, e, true, true, true, false);
    }

    private static void writeExceptionNoInternalNoStackTrace(PbsOutputStream output, Throwable e) {
        PbsExceptionFormatter.writeExceptionInternal(output, e, false, true, false, false);
    }

    private static void writeExceptionInternal(PbsOutputStream output, Throwable e, boolean withInnerException, boolean withExceptionMessage, boolean withStackTrace, boolean withExceptionType) {
        output.writeString(withExceptionType ? e.getClass().getName() : null);
        output.writeString(withExceptionMessage ? e.getMessage() : null);
        if (withStackTrace) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            StringBuilder stackTraceStr = new StringBuilder();
            for (int i = 0; i < stackTrace.length; ++i) {
                stackTraceStr.append(stackTrace[i].toString());
                stackTraceStr.append("\n");
            }
            output.writeString(stackTraceStr.toString());
        } else {
            output.writeString(null);
        }
        if (withInnerException && e.getCause() != null) {
            output.writeBoolean(true);
            PbsExceptionFormatter.writeException(output, e.getCause(), (short)1, false);
        } else {
            output.writeBoolean(false);
        }
    }
}

