/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands;

import com.gigaspaces.internal.io.WindowsRegistryUtils;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsAuditor;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.JavaToNetException;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Dispatcher {
    private static final Logger _logger;
    private static final PbsAuditor _auditor;
    private static final int TRACE_ERROR_LEVEL = 1;
    private static String executingDotnetCoreDllPath;
    private static int xapNetloggingLevel;
    private static boolean _xapNetInitialized;

    public static PbsInputStream executeOnDefaultDomain(PbsOutputStream output) {
        return Dispatcher.execute(output, -1, true);
    }

    public static PbsInputStream execute(PbsOutputStream output, DispatcherObjectProxy proxy) {
        return Dispatcher.execute(output, proxy.contextAppDomainId, !proxy.handleInjected);
    }

    public static PbsInputStream execute(PbsOutputStream output, int contextAppDomainId, boolean useDefaultAppDomain) {
        if (!_xapNetInitialized) {
            Dispatcher.initializeXapNet();
        }
        byte[] inputBuffer = null;
        _auditor.logEnter();
        PbsInputStream input = PbsStreamResource.getExistingInputStream();
        byte[] reusedInputBuffer = input != null ? input.getBuffer() : null;
        int reusedBufferLength = reusedInputBuffer != null ? reusedInputBuffer.length : -1;
        try {
            int contentSize = output.size();
            inputBuffer = Dispatcher.executeCommand(output.getBuffer(), contentSize, reusedInputBuffer, reusedBufferLength, contextAppDomainId, useDefaultAppDomain);
        }
        catch (Throwable e) {
            _auditor.logError();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Unexpected error while dispatching command to .NET: " + e.toString(), e);
            }
            throw new RuntimeException("Failed to execute .NET command.", e);
        }
        finally {
            PbsStreamResource.releasePbsStream((IThreadLocalResource)output);
            _auditor.logExit();
        }
        if (inputBuffer == null) {
            throw new RuntimeException("Unexpected error happened on delegator side, see delegators log for more information");
        }
        if (inputBuffer != reusedInputBuffer) {
            if (input != null) {
                input.setBuffer(inputBuffer);
            } else {
                input = PbsStreamResource.getInputStream((byte[])inputBuffer);
            }
        }
        PbsExceptionFormatter.checkException(input);
        return input;
    }

    private static synchronized void initializeXapNet() {
        if (_xapNetInitialized) {
            return;
        }
        String XapNetLibrariesFolder = "Bin";
        String XapNetBridgeLibraryFileName = "GigaSpaces.JavaToNet.dll";
        String XapNetCoreLibraryFileName = "GigaSpaces.Core.dll";
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Initializing XAP.NET interop component.");
        }
        String xapHome = Dispatcher.getXapHome();
        String xapNetHome = Dispatcher.getXapNetHome(xapHome);
        File bridgeDllFile = new File(xapNetHome + File.separatorChar + "Bin" + File.separatorChar + "GigaSpaces.JavaToNet.dll");
        String bridgeDllPath = bridgeDllFile.getAbsolutePath();
        if (!bridgeDllFile.exists()) {
            throw new JavaToNetException("XAP.NET initialization failed - " + bridgeDllPath + " file is not found");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Loading .NET native bridge library from " + bridgeDllPath);
        }
        System.load(bridgeDllPath);
        Dispatcher.initXapNetLoggingLevel();
        if (executingDotnetCoreDllPath != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Calling initializeDotnet() with preloaded core library path: " + executingDotnetCoreDllPath);
            }
            Dispatcher.initializeDotnet(executingDotnetCoreDllPath, null, xapNetloggingLevel);
        } else {
            String coreDllPath = xapNetHome + "\\" + "Bin" + "\\" + "GigaSpaces.Core.dll";
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Calling initializeDotnet() with default core library path: " + coreDllPath);
            }
            Dispatcher.initializeDotnet(coreDllPath, xapHome, xapNetloggingLevel);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Calling initializeAppDomain()");
            }
            Dispatcher.initializeAppDomain();
        }
        _xapNetInitialized = true;
    }

    private static String getXapHome() {
        String xapHome = SystemInfo.singleton().getXapHome();
        if (!StringUtils.hasLength((String)xapHome)) {
            throw new JavaToNetException("Failed to find XAP home: system property com.gs.home must be initialized to the XAP's home directory.");
        }
        if (!Dispatcher.pathExists(xapHome)) {
            throw new JavaToNetException("Failed to find XAP home: path does not exists - [" + xapHome + "].");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Initializing XAP.NET: XapHome=" + xapHome);
        }
        return xapHome;
    }

    private static String getXapNetHome(String xapHome) {
        String xapNetHome = SystemInfo.singleton().locations().xapNetHome();
        if (!StringUtils.hasLength((String)xapNetHome)) {
            String settingsFile = Dispatcher.getXapNetSettingsFile(xapHome);
            try {
                DocumentBuilder documentBuilder = XmlUtils.getDocumentBuilder();
                Document xmlDocument = documentBuilder.parse(settingsFile);
                Element xmlElement = xmlDocument.getDocumentElement();
                NodeList nodeList = xmlElement.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    String nodeName = node.getNodeName();
                    if (!nodeName.equals("XapNet.Path")) continue;
                    xapNetHome = node.getTextContent();
                    break;
                }
            }
            catch (ParserConfigurationException e) {
                throw new JavaToNetException("Failed to parse XAP.NET settings file [" + settingsFile + "] - " + e);
            }
            catch (SAXException e) {
                throw new JavaToNetException("Failed to parse XAP.NET settings file [" + settingsFile + "] - " + e);
            }
            catch (IOException e) {
                throw new JavaToNetException("Failed to parse XAP.NET settings file [" + settingsFile + "] - " + e);
            }
            if (!StringUtils.hasLength((String)xapNetHome)) {
                throw new JavaToNetException("Failed to find XapNetHome in settings file [" + settingsFile + "].");
            }
            if (xapNetHome.contains("$(XapNet.SettingsFile))")) {
                xapNetHome = xapNetHome.replace("$(XapNet.SettingsFile))", settingsFile);
            }
        }
        if (!Dispatcher.pathExists(xapNetHome)) {
            throw new JavaToNetException("XapNet.Path does not exist [" + xapNetHome + "].");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Initializing XAP.NET: XapNet.Path=" + xapNetHome);
        }
        return xapNetHome;
    }

    private static String getXapNetSettingsFile(String xapHome) {
        String systemPropertyName = "com.gs.xapnet.settingsPath";
        String version = PlatformVersion.getInstance().getId();
        String envrionmentVariable = "XapNet_" + version + "_SettingsPath";
        String registryPath = "Software\\GigaSpaces\\XAP.NET\\" + version;
        String registryValueName = "SettingsPath";
        String defaultPath = xapHome + "\\..\\Config\\Settings.xml";
        String result = System.getProperty("com.gs.xapnet.settingsPath");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Initializing XAP.NET: System property com.gs.xapnet.settingsPath = [" + result + "].");
        }
        if (!StringUtils.hasLength((String)result)) {
            result = System.getenv(envrionmentVariable);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Initializing XAP.NET: Environment variable " + envrionmentVariable + " = [" + result + "].");
            }
        }
        if (!StringUtils.hasLength((String)result)) {
            result = WindowsRegistryUtils.readKeyValueLocalMachine((String)registryPath, (String)"SettingsPath");
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Initializing XAP.NET: Registry path " + registryPath + "\\" + "SettingsPath" + " = [" + result + "].");
            }
        }
        if (!StringUtils.hasLength((String)result) && Dispatcher.pathExists(defaultPath)) {
            result = defaultPath;
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Initializing XAP.NET: Path of settings file not set, trying default location [" + result + "].");
            }
        }
        if (!StringUtils.hasLength((String)result)) {
            throw new JavaToNetException("XAP.NET initialization failed - unable to determine settings file path.\r\nUse one of the following options:\r\n1. System: In Windows Registry, create key [HKEY_LOCAL_MACHINE\\" + registryPath + "] then create a string value called '" + "SettingsPath" + "' which points to the settings file path.\r\n2. System: Add an environment variable called '" + envrionmentVariable + "' which points to the settings file path.\r\n3. Application: Use system property -D" + "com.gs.xapnet.settingsPath" + " to specify the path of the settings file.");
        }
        if (!Dispatcher.pathExists(result)) {
            throw new JavaToNetException("XAP.NET initialization failed - Installation dir does not exist: " + result);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Initializing XAP.NET: XapNetSettingsPath=" + result);
        }
        return result;
    }

    private static void initXapNetLoggingLevel() {
        String propertyName = "com.gs.xapnet.javatonet.logging.level";
        String propertyValue = System.getProperty("com.gs.xapnet.javatonet.logging.level");
        if (StringUtils.hasLength((String)propertyValue)) {
            try {
                xapNetloggingLevel = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException e) {
                throw new JavaToNetException("com.gs.xapnet.javatonet.logging.level system property must be an integer or null.");
            }
        }
    }

    private static boolean pathExists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static synchronized void addCurrentAppDomainContext() {
        Dispatcher.initializeXapNet();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling initializeAppDomain()");
        }
        Dispatcher.initializeAppDomain();
    }

    public static synchronized void initializeXapNetVariables(String dotnetCoreDllPath, int newLoggingLevel) {
        executingDotnetCoreDllPath = dotnetCoreDllPath;
        xapNetloggingLevel = newLoggingLevel;
        Dispatcher.initializeXapNet();
    }

    private static native byte[] executeCommand(byte[] var0, int var1, byte[] var2, int var3, int var4, boolean var5);

    private static native boolean initializeDotnet(String var0, String var1, int var2);

    private static native void initializeAppDomain();

    static {
        executingDotnetCoreDllPath = null;
        xapNetloggingLevel = 1;
        _xapNetInitialized = false;
        GSLogConfigLoader.getLoader();
        _logger = Logger.getLogger("com.gigaspaces.bridge.dispatcher");
        _auditor = new PbsAuditor("PbsDispatcher.ExecuteCommand");
    }
}

