/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands;

import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.FinalizedProxiesHandler;

public abstract class DispatcherObjectProxy {
    private final byte bundleCode;
    public boolean isDisposed;
    private long handleId;
    public final int contextAppDomainId;
    public final boolean handleInjected;
    public final boolean autoDisposeOnGC;

    protected DispatcherObjectProxy(byte bundleCode, long handleId, int contextAppDomainId, boolean handleInjected, boolean autoDisposeOnGC) {
        this.bundleCode = bundleCode;
        this.handleId = handleId;
        this.contextAppDomainId = contextAppDomainId;
        this.handleInjected = handleInjected;
        this.autoDisposeOnGC = autoDisposeOnGC;
    }

    protected DispatcherObjectProxy(byte bundleCode, long handleId, int contextAppDomainId) {
        this(bundleCode, handleId, contextAppDomainId, true, true);
    }

    protected DispatcherObjectProxy() {
        this(-1, -1L, -1, true, false);
    }

    private void dispose(boolean disposing) {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (!disposing && FinalizedProxiesHandler.enqueueDisposal(this.bundleCode, this.handleId, this.contextAppDomainId, this.handleInjected)) {
                return;
            }
            Bundle.executeGenericDestructCommand(this.bundleCode, this);
        }
    }

    protected void setHandleId(long handleId) {
        this.handleId = handleId;
    }

    public long getHandleId() {
        return this.handleId;
    }

    protected void dispose() {
        this.dispose(true);
    }

    protected void finalize() throws Throwable {
        if (this.autoDisposeOnGC) {
            this.dispose(false);
        }
    }
}

