/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands;

import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FinalizedProxiesHandler {
    private static final BlockingQueue<DisposedDispatcherObjectProxy> _finalizedProxies = new LinkedBlockingQueue<DisposedDispatcherObjectProxy>();
    private static final Finalizer _finalizer = new Finalizer();

    private FinalizedProxiesHandler() {
    }

    public static boolean enqueueDisposal(byte bundleCode, long handleId, int contextAppDomainId, boolean handleInjected) {
        DisposedDispatcherObjectProxy disposedDispatcherObjectProxy = new DisposedDispatcherObjectProxy(bundleCode, handleId, contextAppDomainId, handleInjected);
        return _finalizedProxies.offer(disposedDispatcherObjectProxy);
    }

    static {
        _finalizer.setDaemon(true);
        _finalizer.start();
    }

    public static class DisposedDispatcherObjectProxy {
        public byte bundleCode;
        public long handleId;
        public int appDomainId;
        public boolean handleInjected;

        public DisposedDispatcherObjectProxy(byte bundleCode, long handleId, int appDomainId, boolean handleInjected) {
            this.handleInjected = handleInjected;
            this.appDomainId = appDomainId;
            this.handleId = handleId;
            this.bundleCode = bundleCode;
        }

        public String toString() {
            return "DisposedDispatcherObjectProxy [bundleCode=" + this.bundleCode + ", handleId=" + this.handleId + ", appDomainId=" + this.appDomainId + ", handleInjected=" + this.handleInjected + "]";
        }
    }

    private static class Finalizer
    extends GSThread {
        public Finalizer() {
            super("DispatcherObjectProxiesFinalizer-ClassLoader-" + ClassLoaderHelper.getClassLoaderLogName((ClassLoader)ClassLoaderHelper.getContextClassLoader()));
        }

        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        DisposedDispatcherObjectProxy disposedDispatcherObjectProxy = (DisposedDispatcherObjectProxy)_finalizedProxies.take();
                        try {
                            Bundle.executeGenericDestructCommand(disposedDispatcherObjectProxy.bundleCode, disposedDispatcherObjectProxy.handleId, disposedDispatcherObjectProxy.appDomainId, disposedDispatcherObjectProxy.handleInjected);
                            continue block4;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

