/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.eventscallbacks;

import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import net.jini.core.event.RemoteEvent;

public class Notify {
    public static boolean execute(DispatcherObjectProxy proxy, EntryArrivedRemoteEvent arrivedRemoteEvent, boolean isReturnOnlyUid) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)3, (byte)1, proxy.getHandleId());
        output.writeInt(1);
        output.writeBoolean(!isReturnOnlyUid);
        Notify.serializeEventArgs(output, arrivedRemoteEvent, isReturnOnlyUid);
        PbsInputStream input = Dispatcher.execute(output, proxy);
        boolean result = input.readBoolean();
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        return result;
    }

    public static boolean execute(DispatcherObjectProxy proxy, RemoteEvent[] remoteEvents, boolean isReturnOnlyUid) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)3, (byte)1, proxy.getHandleId());
        output.writeInt(remoteEvents.length);
        output.writeBoolean(!isReturnOnlyUid);
        for (int i = 0; i < remoteEvents.length; ++i) {
            Notify.serializeEventArgs(output, (EntryArrivedRemoteEvent)remoteEvents[i], isReturnOnlyUid);
        }
        PbsInputStream input = Dispatcher.execute(output, proxy);
        boolean result = input.readBoolean();
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        return result;
    }

    private static void serializeEventArgs(PbsOutputStream output, EntryArrivedRemoteEvent arrivedRemoteEvent, boolean isReturnOnlyUid) {
        IEntryPacket entryPacket = arrivedRemoteEvent.getEntryPacket();
        if (isReturnOnlyUid) {
            output.writeString(entryPacket.getUID());
        } else {
            PbsEntryPacket packet = (PbsEntryPacket)arrivedRemoteEvent.getEntryPacket();
            PbsEntryFormatter.writePbsEntryPacketLazy((PbsOutputStream)output, (PbsEntryPacket)packet);
        }
        output.writeInt(arrivedRemoteEvent.getNotifyType());
        OperationID operationID = arrivedRemoteEvent.getOperationID();
        if (operationID != null) {
            output.writeBoolean(true);
            output.writeLong(arrivedRemoteEvent.getOperationID().getClientID());
            output.writeLong(arrivedRemoteEvent.getOperationID().getOperationID());
        } else {
            output.writeBoolean(false);
        }
    }
}

