/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.executorcallbacks;

import com.gigaspaces.executor.dotnet.DotNetSpaceTaskAdapterResult;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.serialization.pbs.IDotnetProxyAssociated;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.executorcallbacks.ExecutorCallbacksBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;
import net.jini.core.transaction.Transaction;

public class ExecuteTask {
    public static DotNetSpaceTaskAdapterResult execute(byte[] serializedTask, ISpaceProxy spaceProxy, Transaction tx) {
        Integer contextAppDomain = PbsExecuter.getAssociatedAppDomainId((IDotnetProxyAssociated)spaceProxy);
        if (contextAppDomain == null) {
            throw new UnsupportedOperationException("Current proxy has no context AppDomain. In order to execute a space task on the specified space, it must have been started from .NET application");
        }
        PbsOutputStream output = Bundle.createOutPutStream((byte)9, (byte)1, -1L);
        boolean isAlreadyTargetOfProxy = spaceProxy.isTargetOfADotnetProxy();
        long proxyHandleId = ExecuteTask.serializeExecutionCommand(serializedTask, spaceProxy, tx, output, isAlreadyTargetOfProxy);
        PbsInputStream input = Dispatcher.execute(output, contextAppDomain, false);
        boolean proxyCacheMissing = input.readBoolean();
        if (proxyCacheMissing) {
            PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
            output = Bundle.createOutPutStream((byte)9, (byte)1, -1L);
            proxyHandleId = ExecuteTask.serializeExecutionCommand(serializedTask, spaceProxy, tx, output, false);
            input = Dispatcher.execute(output, contextAppDomain, false);
            if (input.readBoolean()) {
                throw new PBSInternalSpaceException("Received missing cached proxy after a retry with full proxy details");
            }
        }
        DotNetSpaceTaskAdapterResult result = ExecutorCallbacksBundle.deserializeSpaceTaskAdapterResult(input);
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        if (proxyCacheMissing || !isAlreadyTargetOfProxy) {
            spaceProxy.setDotnetProxyHandleId(proxyHandleId);
        }
        return result;
    }

    private static long serializeExecutionCommand(byte[] serializedTask, ISpaceProxy spaceProxy, Transaction tx, PbsOutputStream output, boolean writeAsCached) {
        output.writeBoolean(writeAsCached);
        long proxyHandleId = -1L;
        if (writeAsCached) {
            output.writeLong(spaceProxy.getDotnetProxyHandleId());
        } else {
            proxyHandleId = PbsExecuter.ISpaceProxyBundle.addAndSerializeProxyProperties(output, spaceProxy, null);
        }
        long txId = tx != null ? PbsExecuter.TransactionBundle.addInstance(tx) : -1L;
        output.writeLong(txId);
        output.writeByteArray(serializedTask);
        return proxyHandleId;
    }
}

