/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.executorcallbacks;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.executor.dotnet.DotNetSpaceTaskAdapterResult;
import com.gigaspaces.serialization.pbs.PbsExceptionFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;

public class ExecutorCallbacksBundle {
    public static final byte Execute = 1;
    public static final byte Reduce = 2;
    public static final byte FilterOnResult = 3;
    public static final byte BundleCode = 9;

    public static void serializeAsyncResult(PbsOutputStream output, AsyncResult<DotNetSpaceTaskAdapterResult> asyncResult) {
        Exception exception = asyncResult.getException();
        DotNetSpaceTaskAdapterResult serializedResult = (DotNetSpaceTaskAdapterResult)asyncResult.getResult();
        if (exception != null) {
            output.writeBoolean(true);
            PbsExceptionFormatter.writeException(output, exception, (short)1, false);
            output.writeByteArray(null);
        } else {
            ExecutorCallbacksBundle.serializeDotNetSpaceTaskAdapterResult(output, serializedResult);
        }
    }

    public static void serializeDotNetSpaceTaskAdapterResult(PbsOutputStream output, DotNetSpaceTaskAdapterResult serializedResult) {
        if (serializedResult.isException()) {
            output.writeBoolean(true);
            output.writeShort((short)127);
            output.writeByteArray(serializedResult.getSerializedResult());
            output.writeByteArray(null);
        } else {
            output.writeBoolean(false);
            output.writeByteArray(serializedResult.getSerializedResult());
        }
    }

    public static DotNetSpaceTaskAdapterResult deserializeSpaceTaskAdapterResult(PbsInputStream input) {
        boolean isExceptionResult = input.readBoolean();
        byte[] serializedResult = input.readByteArray();
        return new DotNetSpaceTaskAdapterResult(isExceptionResult, serializedResult);
    }
}

