/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.executorcallbacks;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultFilterEvent;
import com.gigaspaces.executor.dotnet.DotNetSpaceTaskAdapterResult;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.executorcallbacks.ExecutorCallbacksBundle;
import com.j_spaces.core.exception.internal.PBSInternalSpaceException;

public class FilterOnResult {
    private static final byte CONTINUE_CODE = 0;
    private static final byte BREAK_CODE = 1;
    private static final byte SKIP_CODE = 2;
    private static final byte SKIP_AND_BREAK = 3;

    public static AsyncResultFilter.Decision execute(DispatcherObjectProxy proxy, AsyncResultFilterEvent<DotNetSpaceTaskAdapterResult> event) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)9, (byte)3, proxy.getHandleId());
        output.writeInt(event.getTotalExpectedResults());
        ExecutorCallbacksBundle.serializeAsyncResult(output, (AsyncResult<DotNetSpaceTaskAdapterResult>)event.getCurrentResult());
        AsyncResult[] receivedResults = event.getReceivedResults();
        if (receivedResults != null) {
            output.writeInt(receivedResults.length);
            for (int i = 0; i < receivedResults.length; ++i) {
                ExecutorCallbacksBundle.serializeAsyncResult(output, (AsyncResult<DotNetSpaceTaskAdapterResult>)receivedResults[i]);
            }
        } else {
            output.writeInt(-1);
        }
        PbsInputStream input = Dispatcher.execute(output, proxy);
        byte readByte = input.readByte();
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        switch (readByte) {
            case 0: {
                return AsyncResultFilter.Decision.CONTINUE;
            }
            case 1: {
                return AsyncResultFilter.Decision.BREAK;
            }
            case 2: {
                return AsyncResultFilter.Decision.SKIP;
            }
            case 3: {
                return AsyncResultFilter.Decision.SKIP_AND_BREAK;
            }
        }
        throw new PBSInternalSpaceException("Unexpected async filter decision code " + readByte);
    }
}

