/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.persistency;

import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExecuteBulk {
    public static void execute(DispatcherObjectProxy proxy, List<BulkItem> items) throws IOException {
        PbsOutputStream output = Bundle.createOutPutStream((byte)0, (byte)6, proxy.getHandleId());
        ExecuteBulk.serializeBulkItemBatch(output, items);
        PbsStreamResource.releasePbsStream((IThreadLocalResource)Dispatcher.execute(output, proxy));
    }

    private static void serializeBulkItemBatch(PbsOutputStream output, List<BulkItem> items) throws IOException {
        output.writeInt(items.size());
        Iterator<BulkItem> iterate = items.iterator();
        while (iterate.hasNext()) {
            ExecuteBulk.serializeBulkItem(output, iterate.next());
        }
    }

    private static void serializeBulkItem(PbsOutputStream output, BulkItem item) throws IOException {
        IEntryPacket entryPacket = (IEntryPacket)item.getItem();
        PbsEntryFormatter.writeEntry((PbsOutputStream)output, (Object[])entryPacket.getFieldValues(), (String)entryPacket.getTypeName(), (String)entryPacket.getUID(), (int)entryPacket.getVersion(), (boolean)false, (boolean)false, (boolean)true);
        PbsEntryFormatter.writeDynamicProperties((PbsOutputStream)output, (Map)entryPacket.getDynamicProperties());
        output.writeShort(item.getOperation());
    }
}

