/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.persistencyenumerator;

import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnumeratorNextBatch {
    public static List<IEntryPacket> execute(DispatcherObjectProxy proxy, int batchSize) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)7, (byte)1, proxy.getHandleId());
        output.writeInt(batchSize);
        PbsInputStream input = Dispatcher.execute(output, proxy);
        List<IEntryPacket> result = EnumeratorNextBatch.readEntryList(input);
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        return result;
    }

    private static List<IEntryPacket> readEntryList(PbsInputStream input) {
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        ArrayList<IEntryPacket> result = new ArrayList<IEntryPacket>(length);
        for (int i = 0; i < length; ++i) {
            result.add(EnumeratorNextBatch.readEntryWithTypeDescriptorIfNeeded(input));
        }
        return result;
    }

    private static IEntryPacket readEntryWithTypeDescriptorIfNeeded(PbsInputStream input) {
        boolean hasTypeDesc = input.readBoolean();
        ITypeDesc typeDescriptor = hasTypeDesc ? PbsEntryFormatter.readTypeDescriptor((PbsInputStream)input) : null;
        EntryType entryType = PbsEntryFormatter.readEntryType((PbsInputStream)input);
        PbsEntryPacket pbsEntryPacket = new PbsEntryPacket(input, typeDescriptor, entryType);
        pbsEntryPacket.setDynamicProperties((Map)PbsEntryFormatter.readDynamicProperties((PbsInputStream)input));
        pbsEntryPacket.setTTL(Long.MAX_VALUE);
        return pbsEntryPacket;
    }
}

