/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.processingunit;

import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.processingunit.PUDetailsHolder;
import com.gigaspaces.serialization.pbs.commands.processingunit.ServicesDetails;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class Init {
    public static PUDetailsHolder execute(DispatcherObjectProxy proxy, String assemblyFullPath, String implementationName, String[] dependencies, String deploymentDirectory, Properties customProperties, Integer backupId, Integer instanceId, Integer numberOfBackups, Integer numberOfInstances, String schema, String name, UUID contextIdentifier) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)1, (byte)1, 0L);
        Init.serializeCommonVariables(output, assemblyFullPath, implementationName, dependencies, deploymentDirectory);
        output.writeBoolean(true);
        Init.serializeClusterInfo(output, backupId, instanceId, numberOfBackups, numberOfInstances, schema, name);
        return Init.dispatchInitCommand(proxy, customProperties, contextIdentifier, output);
    }

    public static PUDetailsHolder execute(DispatcherObjectProxy proxy, String assemblyFullPath, String implementationName, String[] dependencies, String deploymentDirectory, Properties customProperties, UUID contextIdentifier) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)1, (byte)1, 0L);
        Init.serializeCommonVariables(output, assemblyFullPath, implementationName, dependencies, deploymentDirectory);
        output.writeBoolean(false);
        return Init.dispatchInitCommand(proxy, customProperties, contextIdentifier, output);
    }

    private static PUDetailsHolder dispatchInitCommand(DispatcherObjectProxy proxy, Properties customProperties, UUID contextIdentifier, PbsOutputStream output) {
        output.writeProperties(customProperties);
        output.writeUUID(contextIdentifier);
        PbsInputStream input = Dispatcher.execute(output, proxy);
        long handleId = input.readLong();
        String puDotnetFullyQualifiedName = input.readString();
        String puDotnetShortName = input.readString();
        ServicesDetails serviceDetails = Init.deserializeServiceDetails(input);
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        return new PUDetailsHolder(handleId, puDotnetFullyQualifiedName, puDotnetShortName, serviceDetails);
    }

    private static ServicesDetails deserializeServiceDetails(PbsInputStream input) {
        int length = input.readInt();
        if (length == -1) {
            return null;
        }
        String[] ids = new String[length];
        String[] serviceTypes = new String[length];
        String[] subServiceType = new String[length];
        String[] descriptions = new String[length];
        String[] longDescriptions = new String[length];
        LinkedHashMap[] properties = new LinkedHashMap[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = input.readString();
            serviceTypes[i] = input.readString();
            subServiceType[i] = input.readString();
            descriptions[i] = input.readString();
            longDescriptions[i] = input.readString();
            properties[i] = Init.deserializeServiceProperties(input);
        }
        return new ServicesDetails(ids, serviceTypes, subServiceType, descriptions, longDescriptions, properties);
    }

    private static Map<String, String> deserializeServiceProperties(PbsInputStream input) {
        int propLength = input.readInt();
        if (propLength == -1) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < propLength; ++i) {
            String id = input.readString();
            String value = input.readString();
            result.put(id, value);
        }
        return result;
    }

    private static void serializeCommonVariables(PbsOutputStream output, String assemblyFullPath, String implementationName, String[] dependencies, String deploymentDirectory) {
        output.writeString(assemblyFullPath);
        output.writeString(implementationName);
        output.writeStringArray(dependencies);
        output.writeString(deploymentDirectory);
    }

    private static void serializeClusterInfo(PbsOutputStream output, Integer backupId, Integer instanceId, Integer numberOfBackups, Integer numberOfInstances, String schema, String name) {
        Init.serializeNullableInt(output, backupId);
        Init.serializeNullableInt(output, instanceId);
        Init.serializeNullableInt(output, numberOfBackups);
        Init.serializeNullableInt(output, numberOfInstances);
        output.writeString(schema);
        output.writeString(name);
    }

    private static void serializeNullableInt(PbsOutputStream output, Integer value) {
        output.writeBoolean(value != null);
        if (value != null) {
            output.writeInt(value.intValue());
        }
    }
}

