/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.processingunit;

import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.processingunit.ServicesMonitors;
import java.util.LinkedHashMap;
import java.util.Map;

public class Monitor {
    public static ServicesMonitors execute(DispatcherObjectProxy proxy) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)1, (byte)2, proxy.getHandleId());
        PbsInputStream input = Dispatcher.execute(output, proxy);
        ServicesMonitors monitors = Monitor.deserializeMonitors(input);
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
        return monitors;
    }

    private static ServicesMonitors deserializeMonitors(PbsInputStream input) {
        int monitorLength = input.readInt();
        if (monitorLength == -1) {
            return null;
        }
        String[] interopId = new String[monitorLength];
        String[] ids = new String[monitorLength];
        LinkedHashMap[] servicesMonitors = new LinkedHashMap[monitorLength];
        for (int i = 0; i < monitorLength; ++i) {
            interopId[i] = input.readString();
            ids[i] = input.readString();
            servicesMonitors[i] = Monitor.deserializeMonitor(input);
        }
        return new ServicesMonitors(interopId, ids, servicesMonitors);
    }

    private static Map<String, String> deserializeMonitor(PbsInputStream input) {
        int propLength = input.readInt();
        if (propLength == -1) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < propLength; ++i) {
            String id = input.readString();
            String propertyDetails = input.readString();
            result.put(id, propertyDetails);
        }
        return result;
    }
}

