/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.serialization.pbs.commands.spacefilter;

import com.gigaspaces.serialization.pbs.IThreadLocalResource;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import com.gigaspaces.serialization.pbs.commands.Bundle;
import com.gigaspaces.serialization.pbs.commands.Dispatcher;
import com.gigaspaces.serialization.pbs.commands.DispatcherObjectProxy;
import com.gigaspaces.serialization.pbs.commands.spacefilter.SpaceFilterBundle;
import com.gigaspaces.serialization.pbs.executers.PbsExecuter;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;

public class ProcessTwoEntries {
    public static void execute(DispatcherObjectProxy proxy, SpaceContext context, ISpaceFilterEntry originalEntry, ISpaceFilterEntry updatedEntry, int operationCode) {
        PbsOutputStream output = Bundle.createOutPutStream((byte)2, (byte)4, proxy.getHandleId());
        SpaceFilterBundle.SerializeSpaceContext(output, context);
        Long originalEntryHandleId = SpaceFilterBundle.serializeISpaceFilterEntry(output, originalEntry);
        Long updatedEntryHandleId = SpaceFilterBundle.serializeISpaceFilterEntry(output, updatedEntry);
        output.write(operationCode);
        PbsInputStream input = Dispatcher.execute(output, proxy);
        if (originalEntryHandleId != null) {
            PbsExecuter.IFilterEntryBundle.removeInstance(originalEntryHandleId);
            SpaceFilterBundle.updateISpaceFilterEntryIfNecessary(input, originalEntry);
        }
        if (updatedEntryHandleId != null) {
            PbsExecuter.IFilterEntryBundle.removeInstance(updatedEntryHandleId);
            SpaceFilterBundle.updateISpaceFilterEntryIfNecessary(input, updatedEntry);
        }
        PbsStreamResource.releasePbsStream((IThreadLocalResource)input);
    }
}

